/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.cims;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cims.IncidentAsyncClient;
import com.oracle.bmc.cims.requests.CreateIncidentRequest;
import com.oracle.bmc.cims.requests.GetIncidentRequest;
import com.oracle.bmc.cims.requests.ListIncidentResourceTypesRequest;
import com.oracle.bmc.cims.requests.ListIncidentsRequest;
import com.oracle.bmc.cims.requests.UpdateIncidentRequest;
import com.oracle.bmc.cims.requests.ValidateUserRequest;
import com.oracle.bmc.cims.responses.CreateIncidentResponse;
import com.oracle.bmc.cims.responses.GetIncidentResponse;
import com.oracle.bmc.cims.responses.ListIncidentResourceTypesResponse;
import com.oracle.bmc.cims.responses.ListIncidentsResponse;
import com.oracle.bmc.cims.responses.UpdateIncidentResponse;
import com.oracle.bmc.cims.responses.ValidateUserResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={IncidentAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class IncidentRxClient {
    IncidentAsyncClient client;

    IncidentRxClient(IncidentAsyncClient client) {
        this.client = client;
    }

    public Single<CreateIncidentResponse> createIncident(CreateIncidentRequest request) {
        return Single.create(emitter -> this.client.createIncident(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetIncidentResponse> getIncident(GetIncidentRequest request) {
        return Single.create(emitter -> this.client.getIncident(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIncidentResourceTypesResponse> listIncidentResourceTypes(ListIncidentResourceTypesRequest request) {
        return Single.create(emitter -> this.client.listIncidentResourceTypes(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIncidentsResponse> listIncidents(ListIncidentsRequest request) {
        return Single.create(emitter -> this.client.listIncidents(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateIncidentResponse> updateIncident(UpdateIncidentRequest request) {
        return Single.create(emitter -> this.client.updateIncident(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ValidateUserResponse> validateUser(ValidateUserRequest request) {
        return Single.create(emitter -> this.client.validateUser(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

