/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.certificates;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.certificates.CertificatesAsyncClient;
import com.oracle.bmc.certificates.requests.GetCaBundleRequest;
import com.oracle.bmc.certificates.requests.GetCertificateAuthorityBundleRequest;
import com.oracle.bmc.certificates.requests.GetCertificateBundleRequest;
import com.oracle.bmc.certificates.requests.ListCertificateAuthorityBundleVersionsRequest;
import com.oracle.bmc.certificates.requests.ListCertificateBundleVersionsRequest;
import com.oracle.bmc.certificates.responses.GetCaBundleResponse;
import com.oracle.bmc.certificates.responses.GetCertificateAuthorityBundleResponse;
import com.oracle.bmc.certificates.responses.GetCertificateBundleResponse;
import com.oracle.bmc.certificates.responses.ListCertificateAuthorityBundleVersionsResponse;
import com.oracle.bmc.certificates.responses.ListCertificateBundleVersionsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={CertificatesAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class CertificatesRxClient {
    CertificatesAsyncClient client;

    CertificatesRxClient(CertificatesAsyncClient client) {
        this.client = client;
    }

    public Single<GetCaBundleResponse> getCaBundle(GetCaBundleRequest request) {
        return Single.create(emitter -> this.client.getCaBundle(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetCertificateAuthorityBundleResponse> getCertificateAuthorityBundle(GetCertificateAuthorityBundleRequest request) {
        return Single.create(emitter -> this.client.getCertificateAuthorityBundle(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetCertificateBundleResponse> getCertificateBundle(GetCertificateBundleRequest request) {
        return Single.create(emitter -> this.client.getCertificateBundle(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListCertificateAuthorityBundleVersionsResponse> listCertificateAuthorityBundleVersions(ListCertificateAuthorityBundleVersionsRequest request) {
        return Single.create(emitter -> this.client.listCertificateAuthorityBundleVersions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListCertificateBundleVersionsResponse> listCertificateBundleVersions(ListCertificateBundleVersionsRequest request) {
        return Single.create(emitter -> this.client.listCertificateBundleVersions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

