/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apmconfig;

import com.oracle.bmc.apmconfig.ConfigAsyncClient;
import com.oracle.bmc.apmconfig.requests.CopyConfigurationRequest;
import com.oracle.bmc.apmconfig.requests.CreateConfigRequest;
import com.oracle.bmc.apmconfig.requests.DeleteConfigRequest;
import com.oracle.bmc.apmconfig.requests.ExportConfigurationRequest;
import com.oracle.bmc.apmconfig.requests.GetConfigRequest;
import com.oracle.bmc.apmconfig.requests.ImportConfigurationRequest;
import com.oracle.bmc.apmconfig.requests.ListConfigsRequest;
import com.oracle.bmc.apmconfig.requests.RetrieveNamespaceMetricsRequest;
import com.oracle.bmc.apmconfig.requests.RetrieveNamespacesRequest;
import com.oracle.bmc.apmconfig.requests.TestRequest;
import com.oracle.bmc.apmconfig.requests.UpdateConfigRequest;
import com.oracle.bmc.apmconfig.requests.ValidateSpanFilterPatternRequest;
import com.oracle.bmc.apmconfig.responses.CopyConfigurationResponse;
import com.oracle.bmc.apmconfig.responses.CreateConfigResponse;
import com.oracle.bmc.apmconfig.responses.DeleteConfigResponse;
import com.oracle.bmc.apmconfig.responses.ExportConfigurationResponse;
import com.oracle.bmc.apmconfig.responses.GetConfigResponse;
import com.oracle.bmc.apmconfig.responses.ImportConfigurationResponse;
import com.oracle.bmc.apmconfig.responses.ListConfigsResponse;
import com.oracle.bmc.apmconfig.responses.RetrieveNamespaceMetricsResponse;
import com.oracle.bmc.apmconfig.responses.RetrieveNamespacesResponse;
import com.oracle.bmc.apmconfig.responses.TestResponse;
import com.oracle.bmc.apmconfig.responses.UpdateConfigResponse;
import com.oracle.bmc.apmconfig.responses.ValidateSpanFilterPatternResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ConfigAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ConfigRxClient {
    ConfigAsyncClient client;

    ConfigRxClient(ConfigAsyncClient client) {
        this.client = client;
    }

    public Single<CopyConfigurationResponse> copyConfiguration(CopyConfigurationRequest request) {
        return Single.create(emitter -> this.client.copyConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateConfigResponse> createConfig(CreateConfigRequest request) {
        return Single.create(emitter -> this.client.createConfig(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteConfigResponse> deleteConfig(DeleteConfigRequest request) {
        return Single.create(emitter -> this.client.deleteConfig(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ExportConfigurationResponse> exportConfiguration(ExportConfigurationRequest request) {
        return Single.create(emitter -> this.client.exportConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetConfigResponse> getConfig(GetConfigRequest request) {
        return Single.create(emitter -> this.client.getConfig(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ImportConfigurationResponse> importConfiguration(ImportConfigurationRequest request) {
        return Single.create(emitter -> this.client.importConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListConfigsResponse> listConfigs(ListConfigsRequest request) {
        return Single.create(emitter -> this.client.listConfigs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RetrieveNamespaceMetricsResponse> retrieveNamespaceMetrics(RetrieveNamespaceMetricsRequest request) {
        return Single.create(emitter -> this.client.retrieveNamespaceMetrics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RetrieveNamespacesResponse> retrieveNamespaces(RetrieveNamespacesRequest request) {
        return Single.create(emitter -> this.client.retrieveNamespaces(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<TestResponse> test(TestRequest request) {
        return Single.create(emitter -> this.client.test(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateConfigResponse> updateConfig(UpdateConfigRequest request) {
        return Single.create(emitter -> this.client.updateConfig(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ValidateSpanFilterPatternResponse> validateSpanFilterPattern(ValidateSpanFilterPatternRequest request) {
        return Single.create(emitter -> this.client.validateSpanFilterPattern(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

