/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apiaccesscontrol;

import com.oracle.bmc.apiaccesscontrol.PrivilegedApiWorkRequestAsyncClient;
import com.oracle.bmc.apiaccesscontrol.requests.CancelWorkRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.GetWorkRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ListWorkRequestsRequest;
import com.oracle.bmc.apiaccesscontrol.responses.CancelWorkRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.GetWorkRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ListWorkRequestsResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={PrivilegedApiWorkRequestAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class PrivilegedApiWorkRequestRxClient {
    PrivilegedApiWorkRequestAsyncClient client;

    PrivilegedApiWorkRequestRxClient(PrivilegedApiWorkRequestAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

