/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.oke.kubernetes.client;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.config.model.ExecConfig;
import io.micronaut.kubernetes.client.openapi.credential.KubernetesTokenLoader;
import io.micronaut.kubernetes.client.openapi.credential.model.ExecCredential;
import io.micronaut.kubernetes.client.openapi.credential.model.ExecCredentialStatus;
import io.micronaut.oraclecloud.oke.kubernetes.client.OkeKubernetesClientConfig;
import jakarta.inject.Singleton;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
@Requires(beans={AbstractAuthenticationDetailsProvider.class, OkeKubernetesClientConfig.class})
@Internal
public class OkeKubernetesCredentialLoader
implements KubernetesTokenLoader {
    private static final String EXPECTED_COMMAND = "oci";
    private static final String[] EXPECTED_ARGS = new String[]{"ce", "cluster", "generate-token"};
    private static final String CLUSTER_ID_ARG = "--cluster-id";
    private static final String REGION_ARG = "--region";
    private static final String DELEGATION_TOKEN_HEADER = "opc-obo-token";
    private static final String AUTHORIZATION_HEADER = "authorization";
    private static final String DATE_HEADER = "date";
    private static final String TOKEN_URL_FORMAT = "%s/cluster_request/%s";
    private static final String EXEC_CREDENTIAL_API_VERSION = "client.authentication.k8s.io/v1beta1";
    private static final String EXEC_CREDENTIAL_KIND = "ExecCredential";
    private static final Logger LOG = LoggerFactory.getLogger(OkeKubernetesCredentialLoader.class);
    private static final int ORDER = 5;
    private static final Duration BUFFER = Duration.ofSeconds(60L);
    private final String containerEngineEndpoint;
    private final RequestSigner requestSigner;
    private final KubeConfig kubeConfig;
    private volatile ExecCredential execCredential;

    OkeKubernetesCredentialLoader(@Nullable RequestSignerFactory requestSignerFactory, @NonNull AbstractAuthenticationDetailsProvider authProvider, KubeConfigLoader kubeConfigLoader, @NonNull ContainerEngine containerEngine) {
        this.containerEngineEndpoint = containerEngine.getEndpoint();
        if (requestSignerFactory == null) {
            requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }
        this.requestSigner = requestSignerFactory.createRequestSigner(null, authProvider);
        this.kubeConfig = kubeConfigLoader.getKubeConfig();
    }

    public String getToken() {
        this.setExecCredential();
        return this.execCredential == null ? null : this.execCredential.status().token();
    }

    public int getOrder() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecCredential() {
        if (this.kubeConfig == null || this.kubeConfig.getUser() == null) {
            return;
        }
        ParsedExecCommand command = this.parseCommand(this.kubeConfig.getUser().exec());
        if (command == null) {
            return;
        }
        if (this.shouldLoadCredential()) {
            OkeKubernetesCredentialLoader okeKubernetesCredentialLoader = this;
            synchronized (okeKubernetesCredentialLoader) {
                if (this.shouldLoadCredential()) {
                    try {
                        this.execCredential = this.loadCredential(command);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load exec credential", (Throwable)e);
                    }
                }
            }
        }
    }

    private ParsedExecCommand parseCommand(ExecConfig execConfig) {
        if (execConfig == null) {
            return null;
        }
        if (!EXPECTED_COMMAND.equals(execConfig.command())) {
            return null;
        }
        List args = execConfig.args();
        for (int i = 0; i < EXPECTED_ARGS.length; ++i) {
            if (EXPECTED_ARGS[i].equals(args.get(i))) continue;
            return null;
        }
        String clusterId = null;
        String region = null;
        for (int i = EXPECTED_ARGS.length; i < args.size() - 1; ++i) {
            if (CLUSTER_ID_ARG.equals(args.get(i))) {
                clusterId = (String)args.get(++i);
            }
            if (!REGION_ARG.equals(args.get(i))) continue;
            region = (String)args.get(++i);
        }
        if (clusterId == null) {
            throw new IllegalStateException("Cluster ID is required, but was not found in the kubeconfig exec command");
        }
        return new ParsedExecCommand(region, clusterId);
    }

    private boolean shouldLoadCredential() {
        if (this.execCredential == null) {
            return true;
        }
        ZonedDateTime expiration = this.execCredential.status().expirationTimestamp();
        if (expiration == null) {
            return false;
        }
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        LOG.debug("Check whether credential loading needed, now={}, buffer={}, expiration={}", new Object[]{now, BUFFER, expiration});
        return expiration.isBefore(now.plusSeconds(BUFFER.toSeconds()));
    }

    private ExecCredential loadCredential(ParsedExecCommand command) {
        LOG.debug("Creating OKE kubernetes client credential");
        URI uri = URI.create(String.format(TOKEN_URL_FORMAT, this.containerEngineEndpoint, command.clusterId));
        Map headers = this.requestSigner.signRequest(uri, "GET", Collections.emptyMap(), null);
        UriBuilder builder = UriBuilder.of((URI)uri).queryParam(AUTHORIZATION_HEADER, new Object[]{headers.get(AUTHORIZATION_HEADER)}).queryParam(DATE_HEADER, new Object[]{headers.get(DATE_HEADER)});
        if (headers.containsKey(DELEGATION_TOKEN_HEADER)) {
            builder.queryParam(DELEGATION_TOKEN_HEADER, new Object[]{headers.get(DELEGATION_TOKEN_HEADER)});
        }
        return new ExecCredential(EXEC_CREDENTIAL_API_VERSION, EXEC_CREDENTIAL_KIND, new ExecCredentialStatus(this.base64Encode(builder.toString()), null, null, ZonedDateTime.now().plusMinutes(4L)));
    }

    private String base64Encode(String url) {
        ByteBuffer urlBytes = ByteBuffer.wrap(url.getBytes(StandardCharsets.UTF_8));
        ByteBuffer encoded = Base64.getUrlEncoder().encode(urlBytes);
        return StandardCharsets.UTF_8.decode(encoded).toString();
    }

    private record ParsedExecCommand(String region, String clusterId) {
    }
}

