/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.oke.kubernetes.client;

import com.oracle.bmc.containerengine.ContainerEngineClient;
import com.oracle.bmc.containerengine.model.CreateClusterKubeconfigContentDetails;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.kubernetes.client.openapi.config.AbstractKubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.oraclecloud.oke.kubernetes.client.OkeKubernetesClientConfig;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
@Replaces(value=KubeConfigLoader.class)
@Requires(beans={OkeKubernetesClientConfig.class})
final class OkeKubeConfigLoader
extends AbstractKubeConfigLoader {
    private static final String TOKEN_VERSION = "2.0.0";
    private static final Logger LOG = LoggerFactory.getLogger(OkeKubeConfigLoader.class);
    private final ContainerEngineClient client;
    private final OkeKubernetesClientConfig config;

    OkeKubeConfigLoader(ContainerEngineClient containerEngineClient, OkeKubernetesClientConfig config, ResourceResolver resourceResolver) {
        super(resourceResolver);
        this.client = containerEngineClient;
        this.config = config;
    }

    @Nullable
    protected KubeConfig loadKubeConfig() {
        return this.createCubeConfig(this.config.clusterId(), this.config.endpointType());
    }

    protected KubeConfig createCubeConfig(String okeClusterId, CreateClusterKubeconfigContentDetails.Endpoint endpointType) {
        KubeConfig kubeConfig;
        block10: {
            CreateKubeconfigResponse response;
            LOG.info("Creating remote kubeconfig for cluster id {}", (Object)okeClusterId);
            CreateClusterKubeconfigContentDetails body = CreateClusterKubeconfigContentDetails.builder().tokenVersion(TOKEN_VERSION).endpoint(endpointType).build();
            CreateKubeconfigRequest kubeConfigRequest = CreateKubeconfigRequest.builder().clusterId(okeClusterId).createClusterKubeconfigContentDetails(body).build();
            try {
                response = this.client.createKubeconfig(kubeConfigRequest);
            }
            catch (Exception e) {
                LOG.error("Caught exception when creating kubeconfig for cluster: {}", (Object)okeClusterId, (Object)e);
                throw new IllegalStateException("Unable to create KubeConfig", e);
            }
            LOG.info("Successfully received kubeconfig response for cluster id {}", (Object)okeClusterId);
            InputStream kubeConfig2 = response.getInputStream();
            try {
                kubeConfig = this.loadKubeConfigFromInputStream(kubeConfig2);
                if (kubeConfig2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (kubeConfig2 != null) {
                        try {
                            kubeConfig2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Caught exception when reading kubeconfig for cluster {}", (Object)okeClusterId, (Object)e);
                    throw new RuntimeException("Unable to create kubeClient", e);
                }
            }
            kubeConfig2.close();
        }
        return kubeConfig;
    }
}

