/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.serde.serializers;

import com.oracle.bmc.http.internal.ResponseHelper;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;

@Internal
@Singleton
@BootstrapContextCompatible
final class ErrorCodeAndMessageDeserializer
implements Deserializer<ResponseHelper.ErrorCodeAndMessage> {
    ErrorCodeAndMessageDeserializer() {
    }

    public ResponseHelper.ErrorCodeAndMessage deserialize(Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument type) throws IOException {
        ResponseHelper.ErrorCodeAndMessage.Builder response = ResponseHelper.ErrorCodeAndMessage.builder();
        Decoder objectDecoder = decoder.decodeObject(type);
        String prop = objectDecoder.decodeKey();
        while (prop != null) {
            switch (prop) {
                case "code": {
                    response.code(this.deserializeString(decoder));
                    break;
                }
                case "message": {
                    response.message(this.deserializeString(decoder));
                    break;
                }
                case "originalMessage": {
                    response.originalMessage(this.deserializeString(decoder));
                    break;
                }
                case "originalMessageTemplate": {
                    response.originalMessageTemplate(this.deserializeString(decoder));
                    break;
                }
                case "messageArguments": {
                    response.messageArguments(this.deserializeMap(decoder, context));
                    break;
                }
                default: {
                    decoder.skipValue();
                }
            }
            prop = objectDecoder.decodeKey();
        }
        return response.build();
    }

    private String deserializeString(Decoder decoder) throws IOException {
        return decoder.decodeStringNullable();
    }

    private Map<String, String> deserializeMap(Decoder decoder, Deserializer.DecoderContext context) throws IOException {
        Argument arg = Argument.mapOf(String.class, String.class);
        return (Map)context.findDeserializer(arg).createSpecific(context, arg).deserialize(decoder, context, arg);
    }
}

