/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.serde.serializers;

import com.oracle.bmc.encryption.internal.EncryptionHeader;
import com.oracle.bmc.encryption.internal.EncryptionKey;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import java.util.List;

@Internal
@Singleton
@BootstrapContextCompatible
@Requires(classes={EncryptionHeader.class})
final class EncryptionHeaderDeserializer
implements CustomizableDeserializer<EncryptionHeader> {
    EncryptionHeaderDeserializer() {
    }

    @NonNull
    public Deserializer<EncryptionHeader> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super EncryptionHeader> type) throws SerdeException {
        Argument dtoArg = Argument.of(EncryptionHeaderDto.class);
        Deserializer dtoDeserializer = context.findDeserializer(dtoArg).createSpecific(context, dtoArg);
        return (decoder, context1, type1) -> {
            EncryptionHeaderDto dto = (EncryptionHeaderDto)dtoDeserializer.deserialize(decoder, context1, dtoArg);
            EncryptionHeader result = new EncryptionHeader();
            for (EncryptionKey key : dto.encryptedDataKeys) {
                result.setEncryptionHeader(key, dto.IV, dto.additionalAuthenticatedData);
            }
            return result;
        };
    }

    @Serdeable.Deserializable
    record EncryptionHeaderDto(String additionalAuthenticatedData, String IV, List<EncryptionKey> encryptedDataKeys) {
    }
}

