/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.serde.filter;

import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.serde.PropertyFilter;
import io.micronaut.serde.Serializer;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Internal
@Singleton
@Named(value="explicitlySetFilter")
@BootstrapContextCompatible
final class ExplicitlySetPropertyFilter
implements PropertyFilter {
    ExplicitlySetPropertyFilter() {
    }

    public boolean shouldInclude(Serializer.EncoderContext encoderContext, Serializer<Object> propertySerializer, Object bean, String propertyName, Object propertyValue) {
        if (bean instanceof ExplicitlySetBmcModel) {
            if (propertyValue != null) {
                return true;
            }
            ExplicitlySetBmcModel model = (ExplicitlySetBmcModel)bean;
            return model.wasPropertyExplicitlySet(propertyName);
        }
        return false;
    }
}

