/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@Deprecated
final class StreamWritingHandler
extends ChannelInboundHandlerAdapter {
    public static final int MAX_WRITE_TARGET = 16384;
    private final InputStream stream;
    private final ExecutorService blockingIoExecutor;
    private final Object terminationMessage;
    private boolean done = false;
    private Future<?> currentFuture;

    StreamWritingHandler(InputStream stream, ExecutorService blockingIoExecutor, Object terminationMessage) {
        this.stream = stream;
        this.blockingIoExecutor = blockingIoExecutor;
        this.terminationMessage = terminationMessage;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.writeIfPossible(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        this.writeIfPossible(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.currentFuture != null) {
            this.currentFuture.cancel(true);
        }
    }

    private void writeIfPossible(ChannelHandlerContext ctx) {
        if (!this.done && this.currentFuture == null && ctx.channel().isWritable()) {
            long bytesBeforeUnwritable = ctx.channel().bytesBeforeUnwritable();
            int writeTarget = bytesBeforeUnwritable < 16384L ? (int)bytesBeforeUnwritable : 16384;
            this.currentFuture = this.blockingIoExecutor.submit(new WriteTask(ctx, writeTarget));
        }
    }

    private void complete(ChannelHandlerContext ctx) {
        this.done = true;
        ctx.writeAndFlush(this.terminationMessage);
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private class WriteTask
    implements Runnable {
        private final ChannelHandlerContext ctx;
        private final int targetCount;

        WriteTask(ChannelHandlerContext ctx, int targetCount) {
            this.ctx = ctx;
            this.targetCount = targetCount;
        }

        @Override
        public void run() {
            ByteBuf target = this.ctx.alloc().heapBuffer(this.targetCount);
            try {
                int read = StreamWritingHandler.this.stream.read(target.array(), target.arrayOffset() + target.writerIndex(), target.writableBytes());
                if (read == -1) {
                    this.ctx.channel().eventLoop().execute(() -> {
                        StreamWritingHandler.this.currentFuture = null;
                        StreamWritingHandler.this.complete(this.ctx);
                    });
                } else {
                    target.writerIndex(target.writerIndex() + read);
                    target.retain();
                    this.ctx.channel().eventLoop().execute(() -> {
                        StreamWritingHandler.this.currentFuture = null;
                        this.ctx.writeAndFlush((Object)target, this.ctx.voidPromise());
                        StreamWritingHandler.this.writeIfPossible(this.ctx);
                    });
                }
            }
            catch (InterruptedIOException read) {
            }
            catch (Exception e) {
                this.ctx.fireExceptionCaught((Throwable)e);
            }
            finally {
                target.release();
            }
        }
    }
}

