/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import io.micronaut.oraclecloud.httpclient.netty.DecidedBodyHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

@Deprecated
class StreamReadingHandler
extends DecidedBodyHandler {
    private final Object monitor = new Object();
    private CompositeByteBuf buffer;
    private boolean done = false;
    private Throwable failure;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StreamReadingHandler(ByteBufAllocator alloc) {
        Object object = this.monitor;
        synchronized (object) {
            this.buffer = alloc.compositeBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws Throwable {
        Object object = this.monitor;
        synchronized (object) {
            if (this.buffer == null) {
                if (this.failure != null) {
                    throw this.failure;
                }
                throw new IllegalStateException("Must be added to pipeline first");
            }
            return new Stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onData(ByteBuf data) {
        Object object = this.monitor;
        synchronized (object) {
            this.buffer.addComponent(true, data);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onComplete() {
        Object object = this.monitor;
        synchronized (object) {
            this.done = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean onError(Throwable cause) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.buffer != null) {
                this.failure = cause;
                this.buffer.release();
                this.buffer = null;
                this.monitor.notifyAll();
                return true;
            }
            return false;
        }
    }

    private class Stream
    extends InputStream {
        private Stream() {
        }

        @Override
        public int read() throws IOException {
            byte[] bytes = new byte[1];
            int n = this.read(bytes, 0, 1);
            if (n == -1) {
                return -1;
            }
            assert (n == 1);
            return bytes[0] & 0xFF;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = StreamReadingHandler.this.monitor;
            synchronized (object) {
                while (true) {
                    if (StreamReadingHandler.this.failure != null) {
                        throw new IOException("Failure in netty event loop", StreamReadingHandler.this.failure);
                    }
                    if (StreamReadingHandler.this.buffer == null) {
                        return -1;
                    }
                    if (StreamReadingHandler.this.buffer.isReadable()) {
                        int read = Math.min(len, StreamReadingHandler.this.buffer.readableBytes());
                        StreamReadingHandler.this.buffer.readBytes(b, off, read);
                        StreamReadingHandler.this.buffer.discardSomeReadBytes();
                        return read;
                    }
                    if (StreamReadingHandler.this.done) {
                        StreamReadingHandler.this.buffer.release();
                        StreamReadingHandler.this.buffer = null;
                        continue;
                    }
                    StreamReadingHandler.this.triggerUpstreamRead();
                    StreamReadingHandler.this.checkNotOnEventLoop();
                    try {
                        StreamReadingHandler.this.monitor.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = StreamReadingHandler.this.monitor;
            synchronized (object) {
                if (StreamReadingHandler.this.buffer == null) {
                    return 0;
                }
                return StreamReadingHandler.this.buffer.readableBytes();
            }
        }

        @Override
        public void close() throws IOException {
            StreamReadingHandler.this.removeEarly();
        }
    }
}

