/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.oracle.bmc.http.client.ClientProperty;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.StandardClientProperties;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.oraclecloud.httpclient.netty.ManagedNettyHttpProvider;
import io.micronaut.oraclecloud.httpclient.netty.NettyClientProperties;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Internal
final class NettyHttpClientBuilder
implements HttpClientBuilder {
    final Collection<PrioritizedValue<RequestInterceptor>> requestInterceptors = new ArrayList<PrioritizedValue<RequestInterceptor>>();
    @Nullable
    ManagedNettyHttpProvider managedProvider;
    final Map<ClientProperty<?>, Object> properties = new HashMap();
    String baseUri;
    boolean buffered = true;
    String serviceId = "oci";

    NettyHttpClientBuilder(@Nullable ManagedNettyHttpProvider managedProvider) {
        this.managedProvider = managedProvider;
        if (managedProvider != null) {
            this.property(NettyClientProperties.OCI_NETTY_CLIENT_FILTERS_KEY, managedProvider.nettyClientFilters);
        }
    }

    public HttpClientBuilder baseUri(URI uri) {
        this.baseUri = Objects.requireNonNull(uri, "baseUri").toString();
        return this;
    }

    public HttpClientBuilder baseUri(String uri) {
        this.baseUri = Objects.requireNonNull(uri, "baseUri");
        return this;
    }

    public <T> HttpClientBuilder property(ClientProperty<T> key, T value) {
        if (key == StandardClientProperties.READ_TIMEOUT || key == StandardClientProperties.CONNECT_TIMEOUT || key == StandardClientProperties.ASYNC_POOL_SIZE || key == NettyClientProperties.OCI_NETTY_CLIENT_FILTERS_KEY) {
            this.properties.put(key, value);
        } else if (key == StandardClientProperties.BUFFER_REQUEST) {
            this.buffered = (Boolean)value;
        } else if (key == NettyClientProperties.SERVICE_ID) {
            if (this.managedProvider == null) {
                throw new IllegalArgumentException("Can only configure the service ID for the managed netty http client");
            }
            if (this.managedProvider.mnHttpClientRegistry == null) {
                throw new IllegalArgumentException("Cannot configure the service ID when the client is passed explicitly");
            }
            this.serviceId = (String)value;
        } else {
            if (key == StandardClientProperties.KEY_STORE || key == StandardClientProperties.TRUST_STORE || key == StandardClientProperties.HOSTNAME_VERIFIER || key == StandardClientProperties.SSL_CONTEXT) {
                throw new IllegalArgumentException("The OCI SDK netty client does not support changing the this setting (" + key + ") directly. Please go through the Micronaut HTTP client configuration.");
            }
            if (key == NettyClientProperties.MANAGED_PROVIDER && this.managedProvider == null) {
                this.managedProvider = (ManagedNettyHttpProvider)value;
            } else {
                throw new IllegalArgumentException("Unknown or unsupported HTTP client property " + key);
            }
        }
        return this;
    }

    public HttpClientBuilder registerRequestInterceptor(int priority, RequestInterceptor interceptor) {
        Objects.requireNonNull(interceptor, "interceptor");
        this.requestInterceptors.add(new PrioritizedValue<RequestInterceptor>(priority, interceptor));
        return this;
    }

    public HttpClient build() {
        return new NettyHttpClient(this);
    }

    static final class PrioritizedValue<T> {
        final int priority;
        final T value;

        PrioritizedValue(int priority, T value) {
            this.priority = priority;
            this.value = value;
        }
    }
}

