/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.fasterxml.jackson.core.JacksonException;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.http.client.ClientProperty;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.StandardClientProperties;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.exceptions.ResponseClosedException;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.json.JsonMapper;
import io.micronaut.oraclecloud.httpclient.netty.MicronautHttpRequest;
import io.micronaut.oraclecloud.httpclient.netty.NettyClientProperties;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpClientBuilder;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpRequest;
import io.micronaut.oraclecloud.httpclient.netty.OciNettyClientFilter;
import io.micronaut.oraclecloud.serde.OciSdkMicronautSerializer;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.PrematureChannelClosureException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

@Internal
final class NettyHttpClient
implements HttpClient {
    private static final Map<ClientProperty<?>, Object> EXPECTED_PROPERTIES;
    private static final boolean LEGACY_NETTY_CLIENT;
    final boolean legacyNettyClient;
    final boolean hasContext;
    final boolean ownsThreadPool;
    final String baseUri;
    volatile ThreadLocal<URI> localBaseUri = null;
    final List<RequestInterceptor> requestInterceptors;
    final List<OciNettyClientFilter<?>> nettyClientFilter;
    final ExecutorService blockingIoExecutor;
    final boolean buffered;
    final ConnectionManager connectionManager;
    final RawHttpClient upstreamHttpClient;
    final JsonMapper jsonMapper;

    NettyHttpClient(NettyHttpClientBuilder builder) {
        RawHttpClient mnClient;
        boolean bl = this.legacyNettyClient = LEGACY_NETTY_CLIENT || builder.managedProvider != null && builder.managedProvider.configuration.legacyNettyClient();
        if (builder.managedProvider == null) {
            this.hasContext = false;
            this.ownsThreadPool = true;
            DefaultHttpClientConfiguration cfg = new DefaultHttpClientConfiguration();
            if (builder.properties.containsKey(StandardClientProperties.CONNECT_TIMEOUT)) {
                cfg.setConnectTimeout((Duration)builder.properties.get(StandardClientProperties.CONNECT_TIMEOUT));
            }
            if (builder.properties.containsKey(StandardClientProperties.READ_TIMEOUT)) {
                cfg.setReadTimeout((Duration)builder.properties.get(StandardClientProperties.READ_TIMEOUT));
            }
            mnClient = RawHttpClient.create(null, (HttpClientConfiguration)cfg);
            this.blockingIoExecutor = Executors.newCachedThreadPool();
            this.jsonMapper = OciSdkMicronautSerializer.getDefaultObjectMapper();
        } else {
            this.hasContext = true;
            for (Map.Entry<ClientProperty<?>, Object> entry : builder.properties.entrySet()) {
                if (entry.getValue().equals(EXPECTED_PROPERTIES.get(entry.getKey())) || entry.getKey().equals(NettyClientProperties.OCI_NETTY_CLIENT_FILTERS_KEY)) continue;
                throw new IllegalArgumentException("Cannot change property " + entry.getKey() + " in the managed netty HTTP client. Please configure this setting through the micronaut HTTP client configuration instead. The service ID for the netty client is 'oci'.");
            }
            mnClient = builder.managedProvider.mnHttpClient != null ? builder.managedProvider.mnHttpClient : builder.managedProvider.mnHttpClientRegistry.getRawClient(HttpVersionSelection.forClientConfiguration((HttpClientConfiguration)new DefaultHttpClientConfiguration()), builder.serviceId, null);
            if (builder.managedProvider.ioExecutor == null) {
                this.ownsThreadPool = true;
                this.blockingIoExecutor = Executors.newCachedThreadPool();
            } else {
                this.ownsThreadPool = false;
                this.blockingIoExecutor = builder.managedProvider.ioExecutor;
            }
            this.jsonMapper = builder.managedProvider.jsonMapper;
        }
        this.upstreamHttpClient = mnClient;
        this.connectionManager = this.legacyNettyClient ? ((DefaultHttpClient)mnClient).connectionManager() : null;
        this.baseUri = Objects.requireNonNull(builder.baseUri, "baseUri");
        this.requestInterceptors = builder.requestInterceptors.stream().sorted(Comparator.comparingInt(p -> p.priority)).map(p -> (RequestInterceptor)p.value).collect(Collectors.toList());
        this.nettyClientFilter = builder.properties.containsKey(NettyClientProperties.OCI_NETTY_CLIENT_FILTERS_KEY) ? ((List)builder.properties.get(NettyClientProperties.OCI_NETTY_CLIENT_FILTERS_KEY)).stream().sorted(OrderUtil.COMPARATOR).toList() : Collections.emptyList();
        this.buffered = builder.buffered;
    }

    ByteBufAllocator alloc() {
        return this.connectionManager == null ? ByteBufAllocator.DEFAULT : this.connectionManager.alloc();
    }

    String baseUri() {
        URI loc;
        ThreadLocal<URI> localBaseUri = this.localBaseUri;
        if (localBaseUri != null && (loc = localBaseUri.get()) != null) {
            return loc.toString();
        }
        return this.baseUri;
    }

    public HttpRequest createRequest(Method method) {
        return this.legacyNettyClient ? new NettyHttpRequest(this, method) : new MicronautHttpRequest(this, method);
    }

    public boolean isProcessingException(Exception e) {
        return e instanceof JacksonException || e instanceof PrematureChannelClosureException || e instanceof io.netty.handler.timeout.ReadTimeoutException || e instanceof ReadTimeoutException || e instanceof ResponseClosedException;
    }

    public void close() {
        if (!this.hasContext) {
            try {
                this.upstreamHttpClient.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.ownsThreadPool) {
            this.blockingIoExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEndpoint(String baseTarget) {
        ThreadLocal<URI> localBaseUri = this.localBaseUri;
        if (localBaseUri == null) {
            NettyHttpClient nettyHttpClient = this;
            synchronized (nettyHttpClient) {
                localBaseUri = this.localBaseUri;
                if (localBaseUri == null) {
                    this.localBaseUri = localBaseUri = new ThreadLocal();
                }
            }
        }
        localBaseUri.set(URI.create(baseTarget));
    }

    static {
        LEGACY_NETTY_CLIENT = Boolean.getBoolean("io.micronaut.oraclecloud.httpclient.netty.legacy-netty-client");
        ClientConfiguration cfg = ClientConfiguration.builder().build();
        EXPECTED_PROPERTIES = Map.of(StandardClientProperties.CONNECT_TIMEOUT, Duration.ofMillis(cfg.getConnectionTimeoutMillis()), StandardClientProperties.READ_TIMEOUT, Duration.ofMillis(cfg.getReadTimeoutMillis()), StandardClientProperties.ASYNC_POOL_SIZE, cfg.getMaxAsyncThreads());
    }
}

