/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.Serializer;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.client.RawHttpClientRegistry;
import io.micronaut.json.JsonMapper;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpClientBuilder;
import io.micronaut.oraclecloud.httpclient.netty.OciNettyClientFilter;
import io.micronaut.oraclecloud.httpclient.netty.OciNettyConfiguration;
import io.micronaut.oraclecloud.serde.OciSdkMicronautSerializer;
import io.micronaut.oraclecloud.serde.OciSerdeConfiguration;
import io.micronaut.oraclecloud.serde.OciSerializationConfiguration;
import io.micronaut.serde.ObjectMapper;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

@Singleton
@Internal
@BootstrapContextCompatible
public class ManagedNettyHttpProvider
implements HttpProvider {
    static final String SERVICE_ID = "oci";
    final RawHttpClientRegistry mnHttpClientRegistry;
    final RawHttpClient mnHttpClient;
    final List<OciNettyClientFilter<?>> nettyClientFilters;
    @Nullable
    final ExecutorService ioExecutor;
    final JsonMapper jsonMapper;
    final OciNettyConfiguration configuration;

    @Inject
    public ManagedNettyHttpProvider(RawHttpClientRegistry mnHttpClientRegistry, @Named(value="blocking") @Nullable ExecutorService ioExecutor, ObjectMapper jsonMapper, OciSerdeConfiguration ociSerdeConfiguration, OciSerializationConfiguration ociSerializationConfiguration, @Nullable List<OciNettyClientFilter<?>> nettyClientFilters, @Nullable OciNettyConfiguration configuration) {
        this.mnHttpClientRegistry = mnHttpClientRegistry;
        this.configuration = configuration == null ? new OciNettyConfiguration(false) : configuration;
        this.mnHttpClient = null;
        this.ioExecutor = ioExecutor;
        this.jsonMapper = jsonMapper.cloneWithConfiguration((SerdeConfiguration)ociSerdeConfiguration, (SerializationConfiguration)ociSerializationConfiguration, null);
        this.nettyClientFilters = nettyClientFilters == null ? Collections.emptyList() : nettyClientFilters;
    }

    public ManagedNettyHttpProvider(HttpClient mnHttpClient, ExecutorService ioExecutor, @Nullable List<OciNettyClientFilter<?>> nettyClientFilters) {
        this.mnHttpClientRegistry = null;
        this.mnHttpClient = (RawHttpClient)mnHttpClient;
        this.ioExecutor = ioExecutor;
        this.jsonMapper = OciSdkMicronautSerializer.getDefaultObjectMapper();
        this.nettyClientFilters = nettyClientFilters == null ? Collections.emptyList() : nettyClientFilters;
        this.configuration = new OciNettyConfiguration(false);
    }

    public HttpClientBuilder newBuilder() {
        return new NettyHttpClientBuilder(this);
    }

    public Serializer getSerializer() {
        return new OciSdkMicronautSerializer(this.jsonMapper);
    }
}

