/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;

@Deprecated
final class LimitedBufferingBodyHandler
extends ChannelInboundHandlerAdapter {
    private final int maxBuffer;
    private CompositeByteBuf buffer;
    private boolean overflowed = false;
    private final CompletableFuture<ByteBuf> future = new CompletableFuture();

    LimitedBufferingBodyHandler(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.buffer = ctx.alloc().compositeBuffer();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
        if (!this.future.isDone()) {
            this.future.completeExceptionally(new ClosedChannelException());
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpContent && !this.overflowed) {
            ByteBuf content = ((HttpContent)msg).content();
            int toAdd = Math.min(this.maxBuffer - this.buffer.readableBytes(), content.readableBytes());
            if (toAdd > 0) {
                this.overflowed = toAdd < content.readableBytes();
                ByteBuf slice = content.retainedSlice(this.buffer.readerIndex(), toAdd);
                this.buffer.addComponent(true, slice);
            }
            if (msg instanceof LastHttpContent || this.buffer.readableBytes() >= this.maxBuffer) {
                this.future.complete((ByteBuf)this.buffer);
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.future.completeExceptionally(cause);
        super.exceptionCaught(ctx, cause);
    }

    public CompletableFuture<ByteBuf> getFuture() {
        return this.future;
    }

    public boolean hasOverflowed() {
        return this.overflowed;
    }
}

