/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import io.micronaut.oraclecloud.httpclient.netty.BufferFutureHandler;
import io.micronaut.oraclecloud.httpclient.netty.DecidedBodyHandler;
import io.micronaut.oraclecloud.httpclient.netty.DiscardingHandler;
import io.micronaut.oraclecloud.httpclient.netty.StreamReadingHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Deprecated
final class UndecidedBodyHandler
extends ChannelInboundHandlerAdapter {
    private final Runnable release;
    private final ByteBufAllocator alloc;
    private ChannelHandlerContext context;
    private List<HttpContent> buffer;
    private Throwable failure;
    private boolean decided = false;
    private boolean removed = false;

    UndecidedBodyHandler(Runnable release, ByteBufAllocator alloc) {
        this.release = release;
        this.alloc = alloc;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        this.buffer = new ArrayList<HttpContent>();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.removed = true;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpContent && this.buffer != null) {
            this.buffer.add((HttpContent)msg);
            if (msg instanceof LastHttpContent) {
                ctx.pipeline().remove((ChannelHandler)this);
                this.release.run();
            }
        } else {
            this.context.fireChannelRead(msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.failure == null) {
            this.failure = cause;
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    public boolean hasDecided() {
        return this.decided;
    }

    public void discard() {
        this.replaceWithHandler(DiscardingHandler.INSTANCE);
    }

    public CompletableFuture<InputStream> asInputStream() {
        StreamReadingHandler streamReadingHandler = new StreamReadingHandler(this.alloc);
        if (this.context.executor().inEventLoop()) {
            this.replaceWithHandler(streamReadingHandler);
            try {
                return CompletableFuture.completedFuture(streamReadingHandler.getInputStream());
            }
            catch (Throwable e) {
                CompletableFuture<InputStream> cf = new CompletableFuture<InputStream>();
                cf.completeExceptionally(e);
                return cf;
            }
        }
        Future addFuture = this.context.executor().submit(() -> this.replaceWithHandler(streamReadingHandler));
        CompletableFuture<InputStream> streamFuture = new CompletableFuture<InputStream>();
        addFuture.addListener(future -> {
            if (future.isSuccess()) {
                InputStream stream;
                try {
                    stream = streamReadingHandler.getInputStream();
                }
                catch (Throwable e) {
                    streamFuture.completeExceptionally(e);
                    return;
                }
                streamFuture.complete(stream);
            } else {
                streamFuture.completeExceptionally(future.cause());
            }
        });
        return streamFuture;
    }

    private void replaceWithHandler(DecidedBodyHandler handler) {
        if (this.decided) {
            throw new IllegalStateException("Already replaced");
        }
        this.decided = true;
        if (this.context.executor().inEventLoop()) {
            this.replaceWithHandler0(handler);
        } else {
            this.context.executor().submit(() -> this.replaceWithHandler0(handler));
        }
    }

    public CompletableFuture<ByteBuf> asBuffer() {
        BufferFutureHandler futureHandler = new BufferFutureHandler(this.alloc);
        this.replaceWithHandler(futureHandler);
        return futureHandler.future;
    }

    private void replaceWithHandler0(DecidedBodyHandler handler) {
        if (this.failure != null) {
            handler.onError(this.failure);
            if (this.buffer != null) {
                for (HttpContent httpContent : this.buffer) {
                    httpContent.release();
                }
            }
            return;
        }
        if (this.buffer != null) {
            for (HttpContent message : this.buffer) {
                handler.onContent(message);
            }
            this.buffer = null;
        }
        if (this.removed) {
            handler.onCancel();
        } else {
            ChannelPipeline channelPipeline = this.context.pipeline();
            String string = this.context.name();
            DecidedBodyHandler decidedBodyHandler = handler;
            Objects.requireNonNull(decidedBodyHandler);
            channelPipeline.addAfter(string, null, (ChannelHandler)decidedBodyHandler.new DecidedBodyHandler.HandlerImpl(this.release)).remove((ChannelHandler)this);
        }
    }
}

