/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.oracle.bmc.http.client.HttpResponse;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import io.micronaut.oraclecloud.httpclient.netty.HeaderMap;
import io.micronaut.oraclecloud.httpclient.netty.LimitedBufferingBodyHandler;
import io.micronaut.oraclecloud.httpclient.netty.UndecidedBodyHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;

@Deprecated
final class NettyHttpResponse
implements HttpResponse {
    private final JsonMapper jsonMapper;
    private final io.netty.handler.codec.http.HttpResponse nettyResponse;
    private final LimitedBufferingBodyHandler limitedBufferingBodyHandler;
    private final UndecidedBodyHandler undecidedBodyHandler;
    private final Executor offloadExecutor;

    NettyHttpResponse(JsonMapper jsonMapper, io.netty.handler.codec.http.HttpResponse nettyResponse, LimitedBufferingBodyHandler limitedBufferingBodyHandler, UndecidedBodyHandler undecidedBodyHandler, Executor offloadExecutor) {
        this.jsonMapper = jsonMapper;
        this.nettyResponse = nettyResponse;
        this.limitedBufferingBodyHandler = limitedBufferingBodyHandler;
        this.undecidedBodyHandler = undecidedBodyHandler;
        this.offloadExecutor = offloadExecutor;
    }

    public int status() {
        return this.nettyResponse.status().code();
    }

    public Map<String, List<String>> headers() {
        return new HeaderMap(this.nettyResponse.headers());
    }

    public CompletionStage<InputStream> streamBody() {
        return this.undecidedBodyHandler.asInputStream();
    }

    private CompletableFuture<ByteBuf> bodyAsBuffer() {
        CompletionStage<Object> buffer = this.undecidedBodyHandler.hasDecided() ? this.limitedBufferingBodyHandler.getFuture().thenApply(ByteBuf::retain) : this.undecidedBodyHandler.asBuffer();
        return buffer;
    }

    public <T> CompletionStage<T> body(Class<T> type) {
        return this.thenApply(this.bodyAsBuffer(), buf -> {
            try {
                if (!buf.isReadable()) {
                    Object var3_3 = null;
                    return var3_3;
                }
                Object object = this.jsonMapper.readValue((InputStream)new ByteBufInputStream(buf), type);
                return object;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            finally {
                buf.release();
            }
        });
    }

    public <T> CompletionStage<List<T>> listBody(Class<T> type) {
        Argument listArgument = Argument.listOf(type);
        return this.thenApply(this.bodyAsBuffer(), buf -> {
            try {
                List list = (List)this.jsonMapper.readValue((InputStream)new ByteBufInputStream(buf), listArgument);
                return list;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            finally {
                buf.release();
            }
        });
    }

    public CompletionStage<String> textBody() {
        return this.thenApply(this.bodyAsBuffer(), buf -> {
            try {
                String string = buf.toString(StandardCharsets.UTF_8);
                return string;
            }
            finally {
                buf.release();
            }
        });
    }

    private <T, U> CompletionStage<U> thenApply(CompletionStage<T> stage, Function<? super T, ? extends U> fn) {
        if (this.offloadExecutor == null) {
            return stage.thenApply(fn);
        }
        return stage.thenApplyAsync(fn, this.offloadExecutor);
    }

    public void close() {
        if (!this.undecidedBodyHandler.hasDecided()) {
            this.undecidedBodyHandler.discard();
        }
    }
}

