/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.oraclecloud.httpclient.netty.HeaderMap;
import io.micronaut.oraclecloud.httpclient.netty.LimitedBufferingBodyHandler;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpClient;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpResponse;
import io.micronaut.oraclecloud.httpclient.netty.OciNettyClientFilter;
import io.micronaut.oraclecloud.httpclient.netty.StreamWritingHandler;
import io.micronaut.oraclecloud.httpclient.netty.UndecidedBodyHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

@Deprecated
final class NettyHttpRequest
implements com.oracle.bmc.http.client.HttpRequest {
    private static final long UNKNOWN_CONTENT_LENGTH = -1L;
    private static final String HANDLER_PREFACE = "preface";
    private static final String HANDLER_UNDECIDED_BODY = "undecided-body";
    private static final String HANDLER_LIMITED_BUFFERING = "limited-buffering";
    private final NettyHttpClient client;
    private final Map<String, Object> attributes;
    private final Method method;
    private final HttpHeaders headers;
    private final URI baseUri;
    private final StringBuilder uri;
    private final StringBuilder query;
    private Executor offloadExecutor;
    private BlockHint blockHint;
    private boolean expectContinue;
    private Object returningBody;
    private ByteBuf immediateBody;
    private InputStream blockingBody;
    private long blockingContentLength;

    public NettyHttpRequest(NettyHttpClient nettyHttpClient, Method method) {
        this.client = nettyHttpClient;
        this.method = method;
        String baseUri = this.client.baseUri();
        this.baseUri = URI.create(baseUri);
        this.uri = new StringBuilder(baseUri);
        this.attributes = new HashMap<String, Object>();
        StackWalker.StackFrame frame = StackWalker.getInstance().walk(s -> s.filter(stackFrame -> stackFrame.getClassName().contains("com.oracle.bmc") && !stackFrame.getClassName().contains("com.oracle.bmc.http.internal")).toList()).stream().findFirst().orElse(null);
        this.attributes.put("class_and_method", frame == null ? "N/A" : Arrays.stream(frame.getClassName().split("\\.")).reduce((first, second) -> second).orElse("N/A") + "." + frame.getMethodName());
        this.headers = new DefaultHttpHeaders();
        this.query = new StringBuilder();
    }

    private NettyHttpRequest(NettyHttpRequest from) {
        this.client = from.client;
        this.attributes = new HashMap<String, Object>(from.attributes);
        this.method = from.method;
        this.headers = from.headers.copy();
        this.baseUri = from.baseUri;
        this.uri = new StringBuilder(from.uri);
        this.query = new StringBuilder(from.query);
        this.offloadExecutor = from.offloadExecutor;
        this.blockHint = from.blockHint;
        this.expectContinue = from.expectContinue;
        this.returningBody = from.returningBody;
        this.immediateBody = from.immediateBody == null ? null : from.immediateBody.retainedDuplicate();
        this.blockingBody = from.blockingBody;
        this.blockingContentLength = from.blockingContentLength;
    }

    public Method method() {
        return this.method;
    }

    public com.oracle.bmc.http.client.HttpRequest body(Object body) {
        this.immediateBody = null;
        this.blockingBody = null;
        if (body instanceof String) {
            this.immediateBody = ByteBufUtil.encodeString((ByteBufAllocator)this.client.alloc(), (CharBuffer)CharBuffer.wrap((CharSequence)body), (Charset)StandardCharsets.UTF_8);
            this.returningBody = body;
        } else if (body instanceof InputStream) {
            this.body((InputStream)body, -1L);
        } else if (body == null) {
            this.immediateBody = Unpooled.EMPTY_BUFFER;
            this.returningBody = "";
        } else {
            String json;
            try {
                json = this.client.jsonMapper.writeValueAsString(body);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to process JSON body", e);
            }
            this.immediateBody = ByteBufUtil.encodeString((ByteBufAllocator)this.client.alloc(), (CharBuffer)CharBuffer.wrap(json), (Charset)StandardCharsets.UTF_8);
            this.returningBody = json;
        }
        return this;
    }

    public com.oracle.bmc.http.client.HttpRequest body(InputStream body, long contentLength) {
        this.immediateBody = null;
        this.blockingBody = body;
        this.blockingContentLength = contentLength;
        this.returningBody = body;
        return this;
    }

    public Object body() {
        return this.returningBody;
    }

    public com.oracle.bmc.http.client.HttpRequest appendPathPart(String encodedPathPart) {
        encodedPathPart = encodedPathPart.replace("|", "%7c");
        boolean hasSlashLeft = this.uri.charAt(this.uri.length() - 1) == '/';
        boolean hasSlashRight = encodedPathPart.startsWith("/");
        if (hasSlashLeft) {
            if (hasSlashRight) {
                this.uri.append(encodedPathPart, 1, encodedPathPart.length());
            } else {
                this.uri.append(encodedPathPart);
            }
        } else if (hasSlashRight) {
            this.uri.append(encodedPathPart);
        } else {
            this.uri.append('/').append(encodedPathPart);
        }
        return this;
    }

    public com.oracle.bmc.http.client.HttpRequest query(String name, String value) {
        if (!this.query.isEmpty()) {
            this.query.append('&');
        }
        this.query.append(name).append('=').append(value);
        return this;
    }

    private String buildUri() {
        int length = this.uri.length();
        if (!this.query.isEmpty()) {
            this.uri.append('?').append((CharSequence)this.query);
        }
        String built = this.uri.toString();
        this.uri.setLength(length);
        return built;
    }

    public URI uri() {
        return URI.create(this.buildUri());
    }

    public com.oracle.bmc.http.client.HttpRequest header(String name, String value) {
        this.headers.add(name, (Object)value);
        if (HttpHeaderNames.EXPECT.contentEqualsIgnoreCase((CharSequence)name)) {
            this.expectContinue = HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase((CharSequence)value);
        }
        return this;
    }

    public Map<String, List<String>> headers() {
        return new HeaderMap(this.headers);
    }

    public Object attribute(String name) {
        return this.attributes.get(name);
    }

    public com.oracle.bmc.http.client.HttpRequest removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public com.oracle.bmc.http.client.HttpRequest attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public com.oracle.bmc.http.client.HttpRequest offloadExecutor(Executor offloadExecutor) {
        this.offloadExecutor = offloadExecutor;
        this.blockHint = BlockHint.willBlockThisThread();
        return this;
    }

    public com.oracle.bmc.http.client.HttpRequest copy() {
        return new NettyHttpRequest(this);
    }

    public void discard() {
        if (this.immediateBody != null) {
            this.immediateBody.release();
        }
    }

    public CompletionStage<com.oracle.bmc.http.client.HttpResponse> execute() {
        CompletableFuture<com.oracle.bmc.http.client.HttpResponse> result;
        if (this.blockingBody != null && (this.client.buffered || this.blockingContentLength == -1L) && !this.expectContinue) {
            return CompletableFuture.runAsync(this::bufferBody, this.client.blockingIoExecutor).thenCompose(v -> this.execute());
        }
        for (RequestInterceptor interceptor : this.client.requestInterceptors) {
            interceptor.intercept((com.oracle.bmc.http.client.HttpRequest)this);
        }
        CompletableFuture<com.oracle.bmc.http.client.HttpResponse> last = result = new CompletableFuture<com.oracle.bmc.http.client.HttpResponse>();
        for (OciNettyClientFilter<?> filter : this.client.nettyClientFilter) {
            last = this.runFilter(filter, last);
        }
        DefaultHttpClient.RequestKey rk = new DefaultHttpClient.RequestKey((DefaultHttpClient)this.client.upstreamHttpClient, this.baseUri);
        ExecutionFlow connect = this.client.connectionManager.connect(rk, this.blockHint);
        connect.onComplete((ph, t) -> {
            if (t == null) {
                try {
                    HttpRequest nettyRequest = this.buildNettyRequest((ConnectionManager.PoolHandle)ph);
                    this.initializeChannel((ConnectionManager.PoolHandle)ph, nettyRequest, result);
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                    ph.release();
                }
            } else {
                result.completeExceptionally((Throwable)t);
            }
        });
        return result;
    }

    private void bufferBody() {
        ByteBuf buf = this.blockingContentLength == -1L ? this.client.alloc().buffer() : this.client.alloc().buffer(Math.toIntExact(this.blockingContentLength));
        try {
            int n;
            byte[] arr = new byte[4096];
            while ((n = this.blockingBody.read(arr)) != -1) {
                buf.writeBytes(arr, 0, n);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.blockingBody = null;
        this.immediateBody = buf;
    }

    private boolean delayImmediateBody() {
        return this.expectContinue && this.immediateBody != null && this.immediateBody.isReadable();
    }

    private HttpRequest buildNettyRequest(ConnectionManager.PoolHandle poolHandle) {
        Object nettyRequest;
        boolean hasTransferHeader;
        String uriString = this.buildUri();
        HttpMethod method = switch (this.method) {
            default -> throw new IncompatibleClassChangeError();
            case Method.GET -> HttpMethod.GET;
            case Method.HEAD -> HttpMethod.HEAD;
            case Method.DELETE -> HttpMethod.DELETE;
            case Method.POST -> HttpMethod.POST;
            case Method.PUT -> HttpMethod.PUT;
            case Method.PATCH -> HttpMethod.PATCH;
        };
        URI uri = URI.create(uriString);
        if (!this.headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            this.headers.add((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
        }
        if (!poolHandle.http2()) {
            if (poolHandle.canReturn()) {
                this.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            } else {
                this.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        }
        Object pathAndQuery = uri.getRawPath();
        if (uri.getRawQuery() != null) {
            pathAndQuery = (String)pathAndQuery + "?" + uri.getRawQuery();
        }
        boolean bl = hasTransferHeader = this.headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) || this.headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (this.blockingBody != null) {
            if (!hasTransferHeader) {
                if (this.blockingContentLength == -1L) {
                    this.headers.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                } else {
                    this.headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.blockingContentLength);
                }
            }
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, (String)pathAndQuery, this.headers);
        } else {
            ByteBuf body;
            ByteBuf byteBuf = body = this.immediateBody == null ? Unpooled.EMPTY_BUFFER : this.immediateBody;
            if (!hasTransferHeader) {
                this.headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
            }
            nettyRequest = this.delayImmediateBody() ? new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, (String)pathAndQuery, this.headers) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, (String)pathAndQuery, body, this.headers, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        }
        return nettyRequest;
    }

    private void initializeChannel(final ConnectionManager.PoolHandle ph, HttpRequest nettyRequest, final CompletableFuture<com.oracle.bmc.http.client.HttpResponse> future) {
        final LimitedBufferingBodyHandler limitedBufferingBodyHandler = new LimitedBufferingBodyHandler(4096);
        final UndecidedBodyHandler undecidedBodyHandler = new UndecidedBodyHandler(() -> {
            ph.channel().pipeline().remove(HANDLER_LIMITED_BUFFERING);
            ph.release();
        }, ph.channel().alloc());
        ph.channel().pipeline().addLast(HANDLER_PREFACE, (ChannelHandler)new ChannelInboundHandlerAdapter(){
            boolean skipLast = false;

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (msg instanceof HttpResponse) {
                    HttpResponse response = (HttpResponse)msg;
                    if (response.status().equals((Object)HttpResponseStatus.CONTINUE)) {
                        if (NettyHttpRequest.this.expectContinue) {
                            NettyHttpRequest.this.sendBodyIfNecessary(ctx.channel());
                        }
                        if (!(msg instanceof LastHttpContent)) {
                            this.skipLast = true;
                        }
                    } else {
                        future.complete(new NettyHttpResponse(NettyHttpRequest.this.client.jsonMapper, response, limitedBufferingBodyHandler, undecidedBodyHandler, NettyHttpRequest.this.offloadExecutor));
                        ctx.pipeline().remove((ChannelHandler)this);
                    }
                    if (msg instanceof HttpContent) {
                        ctx.fireChannelRead(msg);
                    }
                } else if (!this.skipLast || !(msg instanceof LastHttpContent)) {
                    ctx.fireChannelRead(msg);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ph.taint();
                future.completeExceptionally(cause);
                ctx.pipeline().remove((ChannelHandler)this);
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                if (!future.isDone()) {
                    ph.taint();
                    future.completeExceptionally((Throwable)new PrematureChannelClosureException());
                }
            }
        }).addLast(HANDLER_LIMITED_BUFFERING, (ChannelHandler)limitedBufferingBodyHandler).addLast(HANDLER_UNDECIDED_BODY, (ChannelHandler)undecidedBodyHandler);
        ph.channel().writeAndFlush((Object)nettyRequest, ph.channel().voidPromise());
        if (!this.expectContinue) {
            this.sendBodyIfNecessary(ph.channel());
        }
        ph.channel().read();
    }

    private void sendBodyIfNecessary(Channel ch) {
        if (this.blockingBody != null) {
            ch.pipeline().addLast(new ChannelHandler[]{new StreamWritingHandler(this.blockingBody, this.client.blockingIoExecutor, new DefaultLastHttpContent())});
        } else if (this.delayImmediateBody()) {
            ch.writeAndFlush((Object)new DefaultLastHttpContent(this.immediateBody), ch.voidPromise());
        }
    }

    private <T> CompletableFuture<com.oracle.bmc.http.client.HttpResponse> runFilter(OciNettyClientFilter<T> filter, CompletableFuture<com.oracle.bmc.http.client.HttpResponse> responseFuture) {
        Object beforeRequestResult = filter.beforeRequest(this);
        return responseFuture.handle((response, error) -> filter.afterResponse(this, (com.oracle.bmc.http.client.HttpResponse)response, (Throwable)error, beforeRequestResult));
    }
}

