/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.oracle.bmc.http.client.HttpResponse;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.json.JsonMapper;
import io.micronaut.oraclecloud.httpclient.netty.LimitedBufferingSubscriber;
import io.micronaut.oraclecloud.httpclient.netty.MicronautHeaderMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.reactivestreams.Subscriber;

@Internal
final class MicronautHttpResponse
implements HttpResponse {
    private final JsonMapper jsonMapper;
    private final io.micronaut.http.HttpResponse<?> mnResponse;
    private final Executor offloadExecutor;
    private LimitedBufferingSubscriber limitedBufferingSubscriber;

    MicronautHttpResponse(JsonMapper jsonMapper, io.micronaut.http.HttpResponse<?> mnResponse, Executor offloadExecutor) {
        this.jsonMapper = jsonMapper;
        this.mnResponse = mnResponse;
        this.offloadExecutor = offloadExecutor;
    }

    public int status() {
        return this.mnResponse.code();
    }

    public Map<String, List<String>> headers() {
        return new MicronautHeaderMap(this.mnResponse.getHeaders());
    }

    private ByteBody byteBody() {
        io.micronaut.http.HttpResponse<?> httpResponse = this.mnResponse;
        if (!(httpResponse instanceof ByteBodyHttpResponse)) {
            throw new UnsupportedOperationException("A micronaut client filter replaced the HTTP response. This is not supported for the micronaut-oracle-cloud HTTP client.");
        }
        ByteBodyHttpResponse bbhr = (ByteBodyHttpResponse)httpResponse;
        return bbhr.byteBody();
    }

    public CompletionStage<InputStream> streamBody() {
        ByteBody byteBody = this.byteBody();
        this.limitedBufferingSubscriber = new LimitedBufferingSubscriber(4096);
        byteBody.split(ByteBody.SplitBackpressureMode.SLOWEST).toByteBufferPublisher().subscribe((Subscriber)this.limitedBufferingSubscriber);
        return CompletableFuture.completedFuture(byteBody.toInputStream());
    }

    private CompletableFuture<byte[]> bodyAsBuffer() {
        if (this.limitedBufferingSubscriber != null) {
            return this.limitedBufferingSubscriber.future;
        }
        return this.byteBody().buffer().thenApply(AvailableByteBody::toByteArray);
    }

    public <T> CompletionStage<T> body(Class<T> type) {
        return this.thenApply(this.bodyAsBuffer(), buf -> {
            try {
                if (((byte[])buf).length == 0) {
                    return null;
                }
                return this.jsonMapper.readValue(buf, type);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletionStage<List<T>> listBody(Class<T> type) {
        Argument listArgument = Argument.listOf(type);
        return this.thenApply(this.bodyAsBuffer(), buf -> {
            try {
                return (List)this.jsonMapper.readValue(buf, listArgument);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletionStage<String> textBody() {
        return this.thenApply(this.bodyAsBuffer(), buf -> new String((byte[])buf, StandardCharsets.UTF_8));
    }

    private <T, U> CompletionStage<U> thenApply(CompletionStage<T> stage, Function<? super T, ? extends U> fn) {
        if (this.offloadExecutor == null) {
            return stage.thenApply(fn);
        }
        return stage.thenApplyAsync(fn, this.offloadExecutor);
    }

    public void close() {
        io.micronaut.http.HttpResponse<?> httpResponse;
        if (this.limitedBufferingSubscriber != null) {
            this.limitedBufferingSubscriber.close();
        }
        if ((httpResponse = this.mnResponse) instanceof ByteBodyHttpResponse) {
            ByteBodyHttpResponse c = (ByteBodyHttpResponse)httpResponse;
            c.close();
        }
    }
}

