/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.oraclecloud.httpclient.netty.MicronautHeaderMap;
import io.micronaut.oraclecloud.httpclient.netty.MicronautHttpResponse;
import io.micronaut.oraclecloud.httpclient.netty.NettyHttpClient;
import io.micronaut.oraclecloud.httpclient.netty.OciNettyClientFilter;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
final class MicronautHttpRequest
implements HttpRequest {
    private static final long UNKNOWN_CONTENT_LENGTH = -1L;
    private final NettyHttpClient client;
    private final Map<String, Object> attributes;
    private final MutableHttpRequest<?> mnRequest;
    private final StringBuilder uri;
    private final StringBuilder query;
    private Executor offloadExecutor;
    private Thread blockHint;
    private boolean expectContinue;
    private Object returningBody;
    @Nullable
    private CloseableByteBody byteBody;

    public MicronautHttpRequest(NettyHttpClient nettyHttpClient, Method method) {
        this.client = nettyHttpClient;
        this.uri = new StringBuilder(this.client.baseUri());
        this.attributes = new HashMap<String, Object>();
        StackWalker.StackFrame frame = this.findFrame().orElse(null);
        this.attributes.put("class_and_method", frame == null ? "N/A" : Arrays.stream(frame.getClassName().split("\\.")).reduce((first, second) -> second).orElse("N/A") + "." + frame.getMethodName());
        this.query = new StringBuilder();
        this.mnRequest = io.micronaut.http.HttpRequest.create((HttpMethod)(switch (method) {
            default -> throw new IncompatibleClassChangeError();
            case Method.GET -> HttpMethod.GET;
            case Method.HEAD -> HttpMethod.HEAD;
            case Method.DELETE -> HttpMethod.DELETE;
            case Method.POST -> HttpMethod.POST;
            case Method.PUT -> HttpMethod.PUT;
            case Method.PATCH -> HttpMethod.PATCH;
        }), (String)"");
    }

    private MicronautHttpRequest(MicronautHttpRequest from) {
        this.client = from.client;
        this.attributes = new HashMap<String, Object>(from.attributes);
        this.mnRequest = MicronautHttpRequest.copyRequest(from.mnRequest);
        this.uri = new StringBuilder(from.uri);
        this.query = new StringBuilder(from.query);
        this.offloadExecutor = from.offloadExecutor;
        this.blockHint = from.blockHint;
        this.expectContinue = from.expectContinue;
        this.returningBody = from.returningBody;
        this.byteBody = from.byteBody == null ? null : from.byteBody.split(ByteBody.SplitBackpressureMode.FASTEST);
    }

    private static MutableHttpRequest<?> copyRequest(io.micronaut.http.HttpRequest<?> original) {
        MutableHttpRequest req = io.micronaut.http.HttpRequest.create((HttpMethod)original.getMethod(), (String)original.getUri().toString());
        for (Map.Entry entry : original.getHeaders()) {
            for (String value : (List)entry.getValue()) {
                req.getHeaders().add((CharSequence)entry.getKey(), (CharSequence)value);
            }
        }
        return req;
    }

    public Method method() {
        return switch (this.mnRequest.getMethod()) {
            case HttpMethod.GET -> Method.GET;
            case HttpMethod.HEAD -> Method.HEAD;
            case HttpMethod.POST -> Method.POST;
            case HttpMethod.PUT -> Method.PUT;
            case HttpMethod.DELETE -> Method.DELETE;
            case HttpMethod.PATCH -> Method.PATCH;
            default -> throw new UnsupportedOperationException("Unsupported method: " + this.mnRequest.getMethodName());
        };
    }

    public HttpRequest body(Object body) {
        if (this.byteBody != null) {
            this.byteBody.close();
        }
        if (body instanceof String) {
            this.byteBody = new AvailableNettyByteBody(ByteBufUtil.encodeString((ByteBufAllocator)this.client.alloc(), (CharBuffer)CharBuffer.wrap((CharSequence)body), (Charset)StandardCharsets.UTF_8));
            this.returningBody = body;
        } else if (body instanceof InputStream) {
            this.body((InputStream)body, -1L);
        } else if (body == null) {
            this.byteBody = AvailableNettyByteBody.empty();
            this.returningBody = "";
        } else {
            String json;
            try {
                json = this.client.jsonMapper.writeValueAsString(body);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to process JSON body", e);
            }
            this.byteBody = new AvailableNettyByteBody(ByteBufUtil.encodeString((ByteBufAllocator)this.client.alloc(), (CharBuffer)CharBuffer.wrap(json), (Charset)StandardCharsets.UTF_8));
            this.returningBody = json;
        }
        return this;
    }

    public HttpRequest body(InputStream body, long contentLength) {
        this.byteBody = InputStreamByteBody.create((InputStream)body, (OptionalLong)(contentLength == -1L ? OptionalLong.empty() : OptionalLong.of(contentLength)), (Executor)this.client.blockingIoExecutor, (ByteBufferFactory)NettyByteBufferFactory.DEFAULT);
        this.returningBody = body;
        return this;
    }

    public Object body() {
        return this.returningBody;
    }

    public HttpRequest appendPathPart(String encodedPathPart) {
        encodedPathPart = encodedPathPart.replace("|", "%7c");
        boolean hasSlashLeft = this.uri.charAt(this.uri.length() - 1) == '/';
        boolean hasSlashRight = encodedPathPart.startsWith("/");
        if (hasSlashLeft) {
            if (hasSlashRight) {
                this.uri.append(encodedPathPart, 1, encodedPathPart.length());
            } else {
                this.uri.append(encodedPathPart);
            }
        } else if (hasSlashRight) {
            this.uri.append(encodedPathPart);
        } else {
            this.uri.append('/').append(encodedPathPart);
        }
        return this;
    }

    public HttpRequest query(String name, String value) {
        if (!this.query.isEmpty()) {
            this.query.append('&');
        }
        this.query.append(name).append('=').append(value);
        return this;
    }

    private String buildUri() {
        int length = this.uri.length();
        if (!this.query.isEmpty()) {
            this.uri.append('?').append((CharSequence)this.query);
        }
        String built = this.uri.toString();
        this.uri.setLength(length);
        return built;
    }

    public URI uri() {
        return URI.create(this.buildUri());
    }

    public HttpRequest header(String name, String value) {
        this.mnRequest.header((CharSequence)name, (CharSequence)value);
        if (HttpHeaderNames.EXPECT.contentEqualsIgnoreCase((CharSequence)name)) {
            this.expectContinue = HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase((CharSequence)value);
        }
        return this;
    }

    public Map<String, List<String>> headers() {
        return new MicronautHeaderMap((HttpHeaders)this.mnRequest.getHeaders());
    }

    public Object attribute(String name) {
        return this.attributes.get(name);
    }

    public HttpRequest removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public HttpRequest attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public HttpRequest offloadExecutor(Executor offloadExecutor) {
        this.offloadExecutor = offloadExecutor;
        this.blockHint = Thread.currentThread();
        return this;
    }

    public HttpRequest copy() {
        return new MicronautHttpRequest(this);
    }

    public void discard() {
        if (this.byteBody != null) {
            this.byteBody.close();
        }
    }

    public CompletionStage<HttpResponse> execute() {
        if (this.byteBody != null && !(this.byteBody instanceof AvailableByteBody) && (this.client.buffered || this.byteBody.expectedLength().isEmpty()) && !this.expectContinue) {
            return this.byteBody.buffer().thenCompose(v -> {
                this.byteBody = v;
                return this.execute();
            });
        }
        for (RequestInterceptor interceptor : this.client.requestInterceptors) {
            interceptor.intercept((HttpRequest)this);
        }
        this.finalizeRequest();
        ArrayList filterState = new ArrayList(this.client.nettyClientFilter.size());
        for (OciNettyClientFilter<?> filter : this.client.nettyClientFilter) {
            filterState.add(filter.beforeRequest(this));
        }
        return ((CompletableFuture)((CompletableFuture)Mono.from((Publisher)this.client.upstreamHttpClient.exchange(this.mnRequest, this.byteBody, this.blockHint)).toFuture().thenApply(r -> new MicronautHttpResponse(this.client.jsonMapper, (io.micronaut.http.HttpResponse<?>)r, this.offloadExecutor))).exceptionallyCompose(e -> this.runResponseFilters(filterState, null, (Throwable)e))).thenCompose(r -> this.runResponseFilters(filterState, (HttpResponse)r, null));
    }

    private CompletableFuture<HttpResponse> runResponseFilters(List<Object> filterState, HttpResponse response, Throwable exception) {
        if (exception instanceof CompletionException && exception.getCause() != null) {
            exception = exception.getCause();
        }
        for (int i = this.client.nettyClientFilter.size() - 1; i >= 0; --i) {
            try {
                this.client.nettyClientFilter.get(i).afterResponse(this, response, exception, filterState.get(i));
                continue;
            }
            catch (Exception e) {
                if (exception == null) {
                    response.close();
                    response = null;
                } else {
                    e.addSuppressed(exception);
                }
                exception = e;
            }
        }
        if (exception != null) {
            return CompletableFuture.failedFuture(exception);
        }
        return CompletableFuture.completedFuture(response);
    }

    private void finalizeRequest() {
        String uriString = this.buildUri();
        URI uri = URI.create(uriString);
        this.mnRequest.uri(uri);
        if (!this.mnRequest.getHeaders().contains("Host")) {
            this.mnRequest.getHeaders().add((CharSequence)HttpHeaderNames.HOST, (CharSequence)uri.getHost());
        }
        if (!this.mnRequest.getHeaders().contains("Content-Length") && !this.mnRequest.getHeaders().contains("Transfer-Encoding")) {
            OptionalLong contentLength;
            OptionalLong optionalLong = contentLength = this.byteBody == null ? OptionalLong.of(0L) : this.byteBody.expectedLength();
            if (contentLength.isPresent()) {
                this.mnRequest.getHeaders().add((CharSequence)"Content-Length", (CharSequence)String.valueOf(contentLength.getAsLong()));
            } else {
                this.mnRequest.getHeaders().add((CharSequence)"Transfer-Encoding", (CharSequence)"chunked");
            }
        }
    }

    private Optional<StackWalker.StackFrame> findFrame() {
        StackWalker walker = StackWalker.getInstance();
        return walker.walk(stream -> stream.dropWhile(frame -> !frame.getClassName().contains("com.oracle.bmc.http.internal") && !frame.getClassName().contains("Client")).skip(2L).dropWhile(nextFrame -> !nextFrame.getClassName().contains("Client")).findFirst());
    }
}

