/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.httpclient.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
final class LimitedBufferingSubscriber
implements Subscriber<ByteBuffer<?>>,
Closeable {
    final CompletableFuture<byte[]> future = new CompletableFuture();
    private final int maxBuffer;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean closed;
    private Subscription subscription;

    LimitedBufferingSubscriber(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription s) {
        boolean closed;
        LimitedBufferingSubscriber limitedBufferingSubscriber = this;
        synchronized (limitedBufferingSubscriber) {
            closed = this.closed;
            if (!closed) {
                this.subscription = s;
            }
        }
        if (closed) {
            s.cancel();
        } else {
            s.request(1L);
        }
    }

    public void onNext(ByteBuffer<?> byteBuffer) {
        try {
            byteBuffer.toInputStream().transferTo(this.buffer);
        }
        catch (IOException e) {
            this.future.completeExceptionally(e);
        }
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        if (this.buffer.size() >= this.maxBuffer) {
            this.future.completeExceptionally(new IOException("Request body was streamed and too large for opportunistic buffering"));
            this.subscription.cancel();
        } else {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable t) {
        this.future.completeExceptionally(t);
    }

    public void onComplete() {
        this.future.complete(this.buffer.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LimitedBufferingSubscriber limitedBufferingSubscriber = this;
        synchronized (limitedBufferingSubscriber) {
            if (!this.closed) {
                if (this.subscription != null) {
                    this.subscription.cancel();
                    this.subscription = null;
                }
                this.closed = true;
            }
        }
    }
}

