/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.RuntimeContext;
import com.fnproject.fn.api.httpgateway.HTTPGatewayContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.io.buffer.ByteArrayBufferFactory;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.oraclecloud.function.OciFunction;
import io.micronaut.oraclecloud.function.http.FnServletRequest;
import io.micronaut.oraclecloud.function.http.FnServletResponse;
import io.micronaut.oraclecloud.function.http.OptionalBufferingInputStream;
import io.micronaut.servlet.http.DefaultServletExchange;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import io.micronaut.servlet.http.ServletHttpResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Singleton
@ReflectiveAccess
public class HttpFunction
extends OciFunction {
    private ServletHttpHandler<InputEvent, OutputEvent> httpHandler;
    private final ConversionService conversionService;
    private final Supplier<Executor> ioExecutor = SupplierUtil.memoized(() -> (Executor)this.getApplicationContext().getBean(Executor.class, Qualifiers.byName((String)"blocking")));

    public HttpFunction() {
        this.conversionService = new DefaultMutableConversionService();
    }

    @Inject
    HttpFunction(ApplicationContext applicationContext) {
        super(applicationContext);
        this.conversionService = applicationContext.getConversionService();
    }

    protected final void setup(RuntimeContext ctx) {
        this.httpHandler = new ServletHttpHandler<InputEvent, OutputEvent>(this.getApplicationContext(), this.conversionService){

            protected ServletExchange<InputEvent, OutputEvent> createExchange(InputEvent request, OutputEvent response) {
                throw new UnsupportedOperationException("Use handleRequest to invoke the function");
            }
        };
        this.setupGateway(ctx);
    }

    protected void setupGateway(@NonNull RuntimeContext ctx) {
    }

    @NonNull
    public final ServletHttpHandler<InputEvent, OutputEvent> getHttpHandler() {
        return this.httpHandler;
    }

    @ReflectiveAccess
    public OutputEvent handleRequest(HTTPGatewayContext gatewayContext, InputEvent inputEvent) {
        FnServletResponse response = new FnServletResponse(gatewayContext, this.conversionService);
        return (OutputEvent)inputEvent.consumeBody(stream -> {
            OptionalBufferingInputStream optionalBufferingInputStream = new OptionalBufferingInputStream((InputStream)stream);
            OptionalLong contentLength = inputEvent.getHeaders().get("Content-Length").map(Long::parseLong).map(OptionalLong::of).orElse(OptionalLong.empty());
            try (CloseableByteBody body = InputStreamByteBody.create((InputStream)optionalBufferingInputStream, (OptionalLong)contentLength, (Executor)this.ioExecutor.get(), (ByteBufferFactory)ByteArrayBufferFactory.INSTANCE);){
                FnServletRequest servletRequest = new FnServletRequest((ByteBody)body, inputEvent, response, gatewayContext, this.conversionService, this.httpHandler.getMediaTypeCodecRegistry());
                DefaultServletExchange exchange = new DefaultServletExchange(servletRequest, (ServletHttpResponse)response);
                try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(servletRequest)).propagate();){
                    this.httpHandler.service((ServletExchange)exchange);
                }
            }
            OutputEvent nativeResponse = response.getNativeResponse();
            optionalBufferingInputStream.bufferIfNecessary();
            return nativeResponse;
        });
    }
}

