/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.httpgateway.HTTPGatewayContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.oraclecloud.function.http.FnMultiValueMap;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
final class FnServletResponse<B>
implements ServletHttpResponse<OutputEvent, B> {
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>(10);
    private final HTTPGatewayContext gatewayContext;
    private final ConversionService conversionService;
    private final ByteArrayOutputStream body = new ByteArrayOutputStream();
    private int status = HttpStatus.OK.getCode();
    private MutableConvertibleValues<Object> attributes;
    private B bodyObject;
    private String reason = HttpStatus.OK.getReason();

    FnServletResponse(HTTPGatewayContext gatewayContext, ConversionService conversionService) {
        this.gatewayContext = gatewayContext;
        this.conversionService = conversionService;
    }

    public OutputEvent getNativeResponse() {
        return OutputEvent.fromBytes((byte[])this.body.toByteArray(), (OutputEvent.Status)(this.status <= 499 ? OutputEvent.Status.Success : OutputEvent.Status.FunctionError), (String)this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE).toString(), (Headers)this.toFnHeaders());
    }

    private Headers toFnHeaders() {
        LinkedHashMap fnHeaders = new LinkedHashMap(this.headers.size());
        this.headers.forEach((name, values) -> fnHeaders.put("Fn-Http-H-" + name, values));
        return Headers.fromMultiHeaderMap(fnHeaders);
    }

    public OutputStream getOutputStream() {
        return this.body;
    }

    public BufferedWriter getWriter() {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)this.body, this.getCharacterEncoding()));
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (cookie instanceof NettyCookie) {
            NettyCookie nettyCookie = (NettyCookie)cookie;
            String encoded = ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
            this.header("Set-Cookie", encoded);
        }
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return new FnResponseHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            FnServletResponse fnServletResponse = this;
            synchronized (fnServletResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return Optional.ofNullable(this.bodyObject);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        this.bodyObject = body;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = status;
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        this.gatewayContext.setStatusCode(status);
        return this;
    }

    public int code() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    private final class FnResponseHeaders
    extends FnMultiValueMap
    implements MutableHttpHeaders {
        FnResponseHeaders() {
            super(FnServletResponse.this.headers, FnServletResponse.this.conversionService);
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            if (header != null && value != null) {
                FnServletResponse.this.headers.computeIfAbsent(header.toString(), s -> new ArrayList(5)).add(value.toString());
            }
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            if (header != null) {
                FnServletResponse.this.headers.remove(header.toString());
            }
            return this;
        }
    }
}

