/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Internal
public class FnMultiValueMap
implements ConvertibleMultiValues<String> {
    protected ConversionService conversionService;
    private final Map<String, List<String>> map;

    public FnMultiValueMap(Map<String, List<String>> map, ConversionService conversionService) {
        this.map = Objects.requireNonNull(map, "Passed map cannot be null");
        this.conversionService = Objects.requireNonNull(conversionService, "ConversionService cannot be null");
    }

    public List<String> getAll(CharSequence name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.map.getOrDefault(name.toString(), Collections.emptyList());
    }

    @Nullable
    public String get(CharSequence name) {
        Iterator<String> i;
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        List<String> values = this.map.get(name.toString());
        if (values != null && (i = values.iterator()).hasNext()) {
            return i.next();
        }
        return null;
    }

    public Set<String> names() {
        return this.map.keySet();
    }

    public Collection<List<String>> values() {
        return this.map.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String v = this.get(name);
        if (v != null) {
            return this.conversionService.convert((Object)v, conversionContext);
        }
        return Optional.empty();
    }

    public void setConversionService(@NonNull ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

