/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.oraclecloud.function.http.FnServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
final class FnBodyBinder<T>
implements AnnotatedRequestArgumentBinder<Body, T> {
    private static final Logger LOG = LoggerFactory.getLogger(FnBodyBinder.class);
    private final MediaTypeCodecRegistry mediaTypeCodeRegistry;
    private final DefaultBodyAnnotationBinder<T> defaultBodyBinder;
    private final ConversionService conversionService;

    protected FnBodyBinder(ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry, DefaultBodyAnnotationBinder<T> defaultBodyAnnotationBinder) {
        this.defaultBodyBinder = defaultBodyAnnotationBinder;
        this.mediaTypeCodeRegistry = mediaTypeCodecRegistry;
        this.conversionService = conversionService;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Argument argument = context.getArgument();
        Class type = argument.getType();
        String name = argument.getAnnotationMetadata().stringValue(Body.class).orElse(null);
        if (source instanceof FnServletRequest) {
            FnServletRequest servletHttpRequest = (FnServletRequest)source;
            if (CharSequence.class.isAssignableFrom(type) && name == null) {
                return servletHttpRequest.consumeBody(inputStream -> {
                    try {
                        String content = IOUtils.readText((BufferedReader)new BufferedReader(new InputStreamReader((InputStream)inputStream, source.getCharacterEncoding())));
                        LOG.trace("Read content of length {} from function body", (Object)content.length());
                        return () -> Optional.of(content);
                    }
                    catch (IOException e) {
                        LOG.debug("Error occurred reading function body: {}", (Object)e.getMessage(), (Object)e);
                        return new ConversionFailedBindingResult(e);
                    }
                });
            }
            MediaType mediaType = source.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            if (servletHttpRequest.isFormSubmission()) {
                return this.bindFormData(servletHttpRequest, name, context);
            }
            MediaTypeCodec codec = this.mediaTypeCodeRegistry.findCodec(mediaType, type).orElse(null);
            if (codec != null) {
                LOG.trace("Decoding function body with codec: {}", (Object)codec.getClass().getSimpleName());
                return servletHttpRequest.consumeBody(inputStream -> {
                    try {
                        if (Publishers.isConvertibleToPublisher((Class)type)) {
                            return this.bindPublisher((Argument<T>)argument, type, codec, (InputStream)inputStream);
                        }
                        return this.bindPojo((Argument<T>)argument, type, codec, (InputStream)inputStream, name);
                    }
                    catch (CodecException e) {
                        LOG.trace("Error occurred decoding function body: {}", (Object)e.getMessage(), (Object)e);
                        return new ConversionFailedBindingResult((Exception)((Object)e));
                    }
                });
            }
        }
        LOG.trace("Not a function request, falling back to default body decoding");
        return this.defaultBodyBinder.bind(context, source);
    }

    private ArgumentBinder.BindingResult<T> bindFormData(FnServletRequest<?> servletHttpRequest, String name, ArgumentConversionContext<T> context) {
        Optional<ConvertibleValues> form = servletHttpRequest.getBody(FnServletRequest.CONVERTIBLE_VALUES_ARGUMENT);
        if (form.isEmpty()) {
            return ArgumentBinder.BindingResult.empty();
        }
        if (name != null) {
            return () -> ((ConvertibleValues)form.get()).get((CharSequence)name, context);
        }
        return () -> this.conversionService.convert((Object)((ConvertibleValues)form.get()).asMap(), context);
    }

    private ArgumentBinder.BindingResult<T> bindPojo(Argument<T> argument, Class<?> type, MediaTypeCodec codec, InputStream inputStream, String name) {
        Object converted;
        Argument requiredArg;
        Argument argument2 = requiredArg = type.isArray() ? Argument.listOf(type.getComponentType()) : argument;
        if (name != null && codec instanceof MapperMediaTypeCodec) {
            MapperMediaTypeCodec jsonCodec = (MapperMediaTypeCodec)codec;
            try {
                JsonNode node = (JsonNode)jsonCodec.getJsonMapper().readValue(inputStream, JsonNode.class);
                JsonNode field = node.get(name);
                if (field == null) {
                    return Optional::empty;
                }
                converted = jsonCodec.decode(requiredArg, field);
            }
            catch (IOException e) {
                throw new CodecException("Error decoding JSON stream for type [JsonNode]: " + e.getMessage(), (Throwable)e);
            }
        } else {
            converted = codec.decode(argument, inputStream);
        }
        if (type.isArray()) {
            converted = ((List)converted).toArray((Object[])Array.newInstance(type.getComponentType(), 0));
        }
        Object[] content = converted;
        LOG.trace("Decoded object from function body: {}", converted);
        return () -> Optional.of(content);
    }

    private ArgumentBinder.BindingResult<T> bindPublisher(Argument<T> argument, Class<T> type, MediaTypeCodec codec, InputStream inputStream) {
        Argument typeArg = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        if (Publishers.isSingle(type)) {
            Object content = codec.decode(typeArg, inputStream);
            Publisher publisher = Publishers.just((Object)content);
            LOG.trace("Decoded object from function body: {}", content);
            Object converted = this.conversionService.convertRequired((Object)publisher, type);
            return () -> Optional.of(converted);
        }
        Argument containerType = Argument.listOf((Class)typeArg.getType());
        if (codec instanceof MapperMediaTypeCodec) {
            MapperMediaTypeCodec jsonCodec = (MapperMediaTypeCodec)codec;
            try {
                JsonNode node = (JsonNode)jsonCodec.getJsonMapper().readValue(inputStream, JsonNode.class);
                Object converted = node.isArray() ? Publishers.convertPublisher((ConversionService)this.conversionService, (Object)Flux.fromIterable((Iterable)node.values()).map(itemNode -> jsonCodec.decode(typeArg, itemNode)), type) : Publishers.convertPublisher((ConversionService)this.conversionService, (Object)Mono.just((Object)jsonCodec.decode(typeArg, node)), type);
                return () -> Optional.of(converted);
            }
            catch (IOException e) {
                throw new CodecException("Error decoding JSON stream for type [JsonNode]: " + e.getMessage(), (Throwable)e);
            }
        }
        Object content = codec.decode(containerType, inputStream);
        LOG.trace("Decoded object from function body: {}", content);
        Flux flowable = Flux.fromIterable((Iterable)((Iterable)content));
        Object converted = this.conversionService.convertRequired((Object)flowable, type);
        return () -> Optional.of(converted);
    }

    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    private record ConversionFailedBindingResult<T>(Exception e) implements ArgumentBinder.BindingResult<T>
    {
        public Optional<T> getValue() {
            return Optional.empty();
        }

        public List<ConversionError> getConversionErrors() {
            return Collections.singletonList(() -> this.e);
        }
    }
}

