/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class OptionalBufferingInputStream
extends InputStream {
    private final Lock lock = new ReentrantLock();
    private final InputStream upstream;
    private byte[] buffered;
    private int bufferedIndex;
    private boolean closed;

    OptionalBufferingInputStream(InputStream upstream) {
        this.upstream = upstream;
    }

    @Override
    public int read() throws IOException {
        byte[] arr1 = new byte[1];
        int n = this.read(arr1);
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            throw new IllegalStateException("Read 0 bytes");
        }
        return arr1[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            if (this.buffered == null) {
                int n = this.upstream.read(b, off, len);
                return n;
            }
            if (this.bufferedIndex >= this.buffered.length) {
                int n = -1;
                return n;
            }
            int n = Math.min(len, this.buffered.length - this.bufferedIndex);
            System.arraycopy(this.buffered, this.bufferedIndex, b, off, n);
            this.bufferedIndex += n;
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.closed = true;
            this.upstream.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    void bufferIfNecessary() {
        block5: {
            this.lock.lock();
            try {
                if (this.closed) break block5;
                try {
                    this.buffered = this.upstream.readAllBytes();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

