/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.httpgateway.HTTPGatewayContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.ConvertibleMultiValuesMap;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.simple.cookies.SimpleCookies;
import io.micronaut.oraclecloud.function.http.FnServletResponse;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
final class FnServletRequest<B>
implements ServletHttpRequest<InputEvent, B>,
ServletExchange<InputEvent, OutputEvent>,
MutableHttpRequest<B>,
ServerHttpRequest<B> {
    private static final String COOKIE_HEADER = "Cookie";
    static final Argument<ConvertibleValues> CONVERTIBLE_VALUES_ARGUMENT = Argument.of(ConvertibleValues.class);
    private final InputEvent inputEvent;
    private final HTTPGatewayContext gatewayContext;
    private final FnServletResponse<Object> response;
    private final ConversionService conversionService;
    private MutableConvertibleValues<Object> attributes;
    private Cookies cookies;
    private final MediaTypeCodecRegistry codecRegistry;
    private final ByteBody byteBody;
    private Object cachedBody;
    private URI uri;

    public FnServletRequest(ByteBody byteBody, InputEvent inputEvent, FnServletResponse<Object> response, HTTPGatewayContext gatewayContext, ConversionService conversionService, MediaTypeCodecRegistry codecRegistry) {
        this.byteBody = byteBody;
        this.inputEvent = inputEvent;
        this.response = response;
        this.gatewayContext = gatewayContext;
        this.conversionService = conversionService;
        this.codecRegistry = codecRegistry;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public InputStream getInputStream() {
        return this.byteBody.toInputStream();
    }

    public <T> T consumeBody(Function<InputStream, T> consumer) {
        return consumer.apply(this.byteBody.split(ByteBody.SplitBackpressureMode.FASTEST).toInputStream());
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), this.getCharacterEncoding()));
    }

    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        Object value;
        if (arg == null) {
            return Optional.empty();
        }
        Class type = arg.getType();
        MediaType contentType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        if (this.isFormSubmission()) {
            ConvertibleMultiValues<CharSequence> form;
            Object object = this.cachedBody;
            if (object instanceof ConvertibleMultiValues) {
                ConvertibleMultiValues<CharSequence> storedForm;
                form = storedForm = (ConvertibleMultiValues<CharSequence>)object;
            } else {
                try {
                    String content = IOUtils.readText((BufferedReader)new BufferedReader(new InputStreamReader(this.byteBody.toInputStream(), this.getCharacterEncoding())));
                    form = this.parseFormData(content);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to parse body", e);
                }
                this.cachedBody = form;
            }
            if (ConvertibleValues.class == type || Object.class == type) {
                return Optional.of(form);
            }
            return this.conversionService.convert((Object)form.asMap(), arg);
        }
        MediaTypeCodec codec = this.codecRegistry.findCodec(contentType, type).orElse(null);
        if (codec == null) {
            return Optional.empty();
        }
        if (ConvertibleValues.class == type || Object.class == type) {
            if (this.cachedBody instanceof ConvertibleValues) {
                return Optional.of(this.cachedBody);
            }
            Map map = (Map)codec.decode(Map.class, this.byteBody.toInputStream());
            ConvertibleValues result = ConvertibleValues.of((Map)map);
            this.cachedBody = result;
            return Optional.of(result);
        }
        if (this.cachedBody != null && this.cachedBody.getClass().isAssignableFrom(type)) {
            return Optional.of(this.cachedBody);
        }
        this.cachedBody = value = this.consumeBody(inputStream -> codec.decode(arg, inputStream));
        return Optional.of(value);
    }

    public InputEvent getNativeRequest() {
        return this.inputEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        Cookies cookies = this.cookies;
        if (cookies == null) {
            FnServletRequest fnServletRequest = this;
            synchronized (fnServletRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    SimpleCookies simpleCookies = new SimpleCookies(this.conversionService);
                    simpleCookies.putAll(this.parseCookiesFromHeader());
                    this.cookies = simpleCookies;
                    cookies = simpleCookies;
                }
            }
        }
        return cookies;
    }

    private Map<CharSequence, io.micronaut.http.cookie.Cookie> parseCookiesFromHeader() {
        HashSet<NettyCookie> result = new HashSet<NettyCookie>();
        for (String header : this.gatewayContext.getHeaders().getAllValues(COOKIE_HEADER)) {
            for (Cookie cookie : ServerCookieDecoder.LAX.decode(header)) {
                result.add(new NettyCookie(cookie));
            }
        }
        return result.stream().collect(Collectors.toMap(io.micronaut.http.cookie.Cookie::getName, Function.identity()));
    }

    @NonNull
    public MutableHttpParameters getParameters() {
        return new FnHttpParameters();
    }

    @NonNull
    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.gatewayContext.getMethod());
    }

    @NonNull
    public String getMethodName() {
        return this.gatewayContext.getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public URI getUri() {
        if (this.uri == null) {
            FnServletRequest fnServletRequest = this;
            synchronized (fnServletRequest) {
                if (this.uri == null) {
                    this.uri = URI.create(this.gatewayContext.getRequestURL());
                }
            }
        }
        return this.uri;
    }

    public MutableHttpRequest<B> cookie(io.micronaut.http.cookie.Cookie cookie) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableHttpRequest<B> uri(URI uri) {
        FnServletRequest fnServletRequest = this;
        synchronized (fnServletRequest) {
            this.uri = uri;
        }
        return this;
    }

    public <T> MutableHttpRequest<T> body(T body) {
        return (FnServletRequest)body;
    }

    @NonNull
    public MutableHttpHeaders getHeaders() {
        return new FnHttpHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            FnServletRequest fnServletRequest = this;
            synchronized (fnServletRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.getBody(CONVERTIBLE_VALUES_ARGUMENT);
    }

    public ServletHttpRequest<InputEvent, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<OutputEvent, ? super Object> getResponse() {
        return this.response;
    }

    public void setConversionService(@NonNull ConversionService conversionService) {
    }

    public boolean isFormSubmission() {
        MediaType contentType = this.getContentType().orElse(null);
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    private ConvertibleMultiValues<CharSequence> parseFormData(String body) {
        Map parameterValues = new QueryStringDecoder(body, false).parameters();
        Iterator iterator = parameterValues.entrySet().iterator();
        while (iterator.hasNext()) {
            List value = (List)iterator.next().getValue();
            if (!value.isEmpty() && !StringUtils.isEmpty((CharSequence)((CharSequence)value.get(0)))) continue;
            iterator.remove();
        }
        return new ConvertibleMultiValuesMap(parameterValues, this.conversionService);
    }

    public MutableHttpRequest<B> mutate() {
        FnServletRequest<B> request = new FnServletRequest<B>(this.byteBody, this.inputEvent, this.response, this.gatewayContext, this.conversionService, this.codecRegistry);
        request.cookies = this.cookies;
        request.attributes = this.attributes;
        return request;
    }

    @NonNull
    public ByteBody byteBody() {
        return this.byteBody;
    }

    private final class FnHttpParameters
    implements MutableHttpParameters {
        private FnHttpParameters() {
        }

        public List<String> getAll(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getQueryParameters().getValues(name.toString());
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getQueryParameters().get(name.toString()).orElse(null);
            }
            return null;
        }

        public Set<String> names() {
            return FnServletRequest.this.gatewayContext.getQueryParameters().getAll().keySet();
        }

        public Collection<List<String>> values() {
            return FnServletRequest.this.gatewayContext.getQueryParameters().getAll().values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            if (name != null) {
                Optional v = FnServletRequest.this.gatewayContext.getQueryParameters().get(name.toString());
                return v.flatMap(s -> FnServletRequest.this.conversionService.convert(s, conversionContext));
            }
            return Optional.empty();
        }

        public MutableHttpParameters add(CharSequence name, List<CharSequence> values) {
            FnServletRequest.this.gatewayContext.getQueryParameters().getAll().put(name.toString(), values.stream().map(Object::toString).toList());
            return this;
        }

        public void setConversionService(@NonNull ConversionService conversionService) {
        }
    }

    private final class FnHttpHeaders
    implements MutableHttpHeaders {
        private FnHttpHeaders() {
        }

        public List<String> getAll(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getHeaders().getAllValues(name.toString());
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getHeaders().get(name.toString()).orElse(null);
            }
            return null;
        }

        public Set<String> names() {
            return new HashSet<String>(FnServletRequest.this.gatewayContext.getHeaders().keys());
        }

        public Collection<List<String>> values() {
            return FnServletRequest.this.gatewayContext.getHeaders().asMap().values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            if (name != null) {
                Optional v = FnServletRequest.this.gatewayContext.getHeaders().get(name.toString());
                return v.flatMap(s -> FnServletRequest.this.conversionService.convert(s, conversionContext));
            }
            return Optional.empty();
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            FnServletRequest.this.gatewayContext.getHeaders().addHeader(header.toString(), value.toString(), new String[0]);
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            FnServletRequest.this.gatewayContext.getHeaders().removeHeader(header.toString());
            return this;
        }

        public void setConversionService(@NonNull ConversionService conversionService) {
        }
    }
}

