/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http.test;

import com.sun.net.httpserver.HttpHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.oraclecloud.function.http.test.FnHttpExchange;
import io.micronaut.oraclecloud.function.http.test.HttpHandlerApplicationContextProvider;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;

@Internal
@Factory
public class EmbeddedServerFactory {
    @Named(value="HttpServer")
    @Singleton
    ApplicationContextProvider createFunction(ApplicationContext applicationContext, @Property(name="fn.test.config") @MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.UNDER_SCORE_SEPARATED) Map<String, String> testConfig) {
        return new HttpHandlerApplicationContextProvider(new FnHttpExchange(testConfig, applicationContext.getEnvironment().getActiveNames()), applicationContext);
    }

    @Singleton
    HttpHandler createHandler(@Named(value="HttpServer") ApplicationContextProvider applicationContextProvider) {
        if (applicationContextProvider instanceof HttpHandlerApplicationContextProvider) {
            HttpHandlerApplicationContextProvider function = (HttpHandlerApplicationContextProvider)applicationContextProvider;
            return function.getHttpHandler();
        }
        throw new ConfigurationException("ApplicationContextProvider with name qualifier HttpServer should be of type HttpFunction");
    }
}

