/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http.test;

import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.testing.FnEventBuilder;
import com.fnproject.fn.testing.FnResult;
import com.fnproject.fn.testing.FnTestingRule;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpStatus;
import io.micronaut.oraclecloud.function.http.HttpFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
class FnHttpExchange
implements HttpHandler {
    private final Set<String> environments;
    private Map<String, String> testConfig;

    FnHttpExchange(Map<String, String> testConfig, Set<String> environments) {
        this.environments = environments;
        this.testConfig = testConfig;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        FnTestingRule fn = FnTestingRule.createDefault();
        this.testConfig.forEach((arg_0, arg_1) -> ((FnTestingRule)fn).setConfig(arg_0, arg_1));
        fn.addSharedClassPrefix("org.slf4j.");
        fn.addSharedClassPrefix("com.sun.");
        String requestURI = exchange.getRequestURI().toString();
        FnEventBuilder eventBuilder = fn.givenEvent().withHeader("Fn-Http-Request-Url", requestURI).withHeader("Fn-Http-Method", exchange.getRequestMethod());
        Set<String> headerNames = exchange.getRequestHeaders().keySet();
        for (String headerName : headerNames) {
            eventBuilder.withHeader("Fn-Http-H-" + headerName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)exchange.getRequestHeaders().get(headerName)));
        }
        HttpMethod httpMethod = HttpMethod.parse((String)exchange.getRequestMethod());
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
            try (InputStream requestBody2 = exchange.getRequestBody();){
                eventBuilder.withBody(requestBody2);
            }
            catch (IOException requestBody2) {
                // empty catch block
            }
        }
        eventBuilder.enqueue();
        String envs = System.getProperty("micronaut.environments");
        System.setProperty("micronaut.environments", String.join((CharSequence)",", this.environments));
        fn.thenRun(HttpFunction.class, "handleRequest");
        if (envs != null) {
            System.setProperty("micronaut.environments", envs);
        }
        FnResult outputEvent = fn.getOnlyResult();
        HttpStatus httpStatus = outputEvent.getHeaders().get("Fn-Http-Status").map(s -> HttpStatus.valueOf((int)Integer.parseInt(s))).orElseGet(() -> outputEvent.getStatus() == OutputEvent.Status.Success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR);
        byte[] bodyAsBytes = outputEvent.getBodyAsBytes();
        outputEvent.getHeaders().asMap().forEach((key, strings) -> {
            String httpKey;
            if (key.startsWith("Fn-Http-H-") && StringUtils.isNotEmpty((CharSequence)(httpKey = key.substring("Fn-Http-H-".length())))) {
                exchange.getResponseHeaders().put(httpKey, (List<String>)strings);
            }
        });
        exchange.sendResponseHeaders(httpStatus.getCode(), bodyAsBytes.length);
        if (bodyAsBytes.length > 0) {
            try (OutputStream responseBody = exchange.getResponseBody();){
                responseBody.write(bodyAsBytes);
                responseBody.flush();
            }
        }
        exchange.close();
    }
}

