/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.certificates.ssl;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.http.server.netty.ssl.CertificateProvidedSslBuilder;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.oraclecloud.certificates.events.CertificateEvent;
import io.micronaut.oraclecloud.certificates.ssl.DelegatedSslContext;
import io.micronaut.runtime.event.annotation.EventListener;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import jakarta.inject.Singleton;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Optional;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Replaces(value=CertificateProvidedSslBuilder.class)
public final class OracleCloudSSLContextBuilder
implements ServerSslBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OracleCloudSSLContextBuilder.class);
    private DelegatedSslContext delegatedSslContext = new DelegatedSslContext(null);
    private final ServerSslConfiguration ssl;

    public OracleCloudSSLContextBuilder(ServerSslConfiguration ssl) {
        this.ssl = ssl;
    }

    @EventListener
    void onNewCertificate(CertificateEvent certificateEvent) {
        block3: {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New certificate received and replaced the proxied SSL context");
                }
                ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
                chain.add(certificateEvent.certificate());
                chain.addAll(certificateEvent.intermediate());
                SslContext sslContext = SslContextBuilder.forServer((PrivateKey)certificateEvent.privateKey(), (X509Certificate[])chain.toArray(new X509Certificate[0])).build();
                this.delegatedSslContext.setNewSslContext(sslContext);
            }
            catch (SSLException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Failed to build the SSL context", (Throwable)e);
            }
        }
    }

    public ServerSslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public Optional<SslContext> build() {
        return Optional.of(this.delegatedSslContext);
    }
}

