/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.certificates.background;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.oraclecloud.certificates.services.OracleCloudCertificateService;
import io.micronaut.scheduling.annotation.Scheduled;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="oci.certificates.enabled", value="true")
@Context
@Internal
public final class OracleCloudCertificationRefresherTask {
    private static final Logger LOG = LoggerFactory.getLogger(OracleCloudCertificationRefresherTask.class);
    private final OracleCloudCertificateService oracleCloudCertificateService;

    public OracleCloudCertificationRefresherTask(OracleCloudCertificateService oracleCloudCertificateService) {
        this.oracleCloudCertificateService = oracleCloudCertificateService;
        oracleCloudCertificateService.refreshCertificate();
    }

    @Scheduled(fixedDelay="${oci.certificates.refresh.frequency:24h}", initialDelay="${oci.certificates.refresh.delay:24h}")
    public void backgroundRenewal() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running background/scheduled renewal process");
        }
        try {
            this.oracleCloudCertificateService.refreshCertificate();
        }
        catch (Exception e) {
            LOG.error("There was error during refreshing certificate process", (Throwable)e);
        }
    }
}

