/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.wlms;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.wlms.WeblogicManagementServiceConfigurationAsyncClient;
import com.oracle.bmc.wlms.requests.GetConfigurationRequest;
import com.oracle.bmc.wlms.requests.UpdateConfigurationRequest;
import com.oracle.bmc.wlms.responses.GetConfigurationResponse;
import com.oracle.bmc.wlms.responses.UpdateConfigurationResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={WeblogicManagementServiceConfigurationAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WeblogicManagementServiceConfigurationReactorClient {
    WeblogicManagementServiceConfigurationAsyncClient client;

    WeblogicManagementServiceConfigurationReactorClient(WeblogicManagementServiceConfigurationAsyncClient client) {
        this.client = client;
    }

    public Mono<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request) {
        return Mono.create(sink -> this.client.getConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request) {
        return Mono.create(sink -> this.client.updateConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

