/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.vbsinst;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.vbsinst.VbsInstanceAsyncClient;
import com.oracle.bmc.vbsinst.requests.ChangeVbsInstanceCompartmentRequest;
import com.oracle.bmc.vbsinst.requests.CreateVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.DeleteVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetWorkRequestRequest;
import com.oracle.bmc.vbsinst.requests.ListVbsInstancesRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vbsinst.requests.UpdateVbsInstanceRequest;
import com.oracle.bmc.vbsinst.responses.ChangeVbsInstanceCompartmentResponse;
import com.oracle.bmc.vbsinst.responses.CreateVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.DeleteVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetWorkRequestResponse;
import com.oracle.bmc.vbsinst.responses.ListVbsInstancesResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestsResponse;
import com.oracle.bmc.vbsinst.responses.UpdateVbsInstanceResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={VbsInstanceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class VbsInstanceReactorClient {
    VbsInstanceAsyncClient client;

    VbsInstanceReactorClient(VbsInstanceAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeVbsInstanceCompartmentResponse> changeVbsInstanceCompartment(ChangeVbsInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeVbsInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateVbsInstanceResponse> createVbsInstance(CreateVbsInstanceRequest request) {
        return Mono.create(sink -> this.client.createVbsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteVbsInstanceResponse> deleteVbsInstance(DeleteVbsInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteVbsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetVbsInstanceResponse> getVbsInstance(GetVbsInstanceRequest request) {
        return Mono.create(sink -> this.client.getVbsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListVbsInstancesResponse> listVbsInstances(ListVbsInstancesRequest request) {
        return Mono.create(sink -> this.client.listVbsInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateVbsInstanceResponse> updateVbsInstance(UpdateVbsInstanceRequest request) {
        return Mono.create(sink -> this.client.updateVbsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

