/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.streaming;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAsyncClient;
import com.oracle.bmc.streaming.requests.ConsumerCommitRequest;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.requests.CreateCursorRequest;
import com.oracle.bmc.streaming.requests.CreateGroupCursorRequest;
import com.oracle.bmc.streaming.requests.GetGroupRequest;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.requests.PutMessagesRequest;
import com.oracle.bmc.streaming.requests.UpdateGroupRequest;
import com.oracle.bmc.streaming.responses.ConsumerCommitResponse;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.streaming.responses.CreateCursorResponse;
import com.oracle.bmc.streaming.responses.CreateGroupCursorResponse;
import com.oracle.bmc.streaming.responses.GetGroupResponse;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.streaming.responses.PutMessagesResponse;
import com.oracle.bmc.streaming.responses.UpdateGroupResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={StreamAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class StreamReactorClient {
    StreamAsyncClient client;

    StreamReactorClient(StreamAsyncClient client) {
        this.client = client;
    }

    public Mono<ConsumerCommitResponse> consumerCommit(ConsumerCommitRequest request) {
        return Mono.create(sink -> this.client.consumerCommit(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ConsumerHeartbeatResponse> consumerHeartbeat(ConsumerHeartbeatRequest request) {
        return Mono.create(sink -> this.client.consumerHeartbeat(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateCursorResponse> createCursor(CreateCursorRequest request) {
        return Mono.create(sink -> this.client.createCursor(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateGroupCursorResponse> createGroupCursor(CreateGroupCursorRequest request) {
        return Mono.create(sink -> this.client.createGroupCursor(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetGroupResponse> getGroup(GetGroupRequest request) {
        return Mono.create(sink -> this.client.getGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMessagesResponse> getMessages(GetMessagesRequest request) {
        return Mono.create(sink -> this.client.getMessages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<PutMessagesResponse> putMessages(PutMessagesRequest request) {
        return Mono.create(sink -> this.client.putMessages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateGroupResponse> updateGroup(UpdateGroupRequest request) {
        return Mono.create(sink -> this.client.updateGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

