/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.streaming;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAdminAsyncClient;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={StreamAdminAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class StreamAdminReactorClient {
    StreamAdminAsyncClient client;

    StreamAdminReactorClient(StreamAdminAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeConnectHarnessCompartmentResponse> changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeConnectHarnessCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeStreamCompartmentResponse> changeStreamCompartment(ChangeStreamCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeStreamCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeStreamPoolCompartmentResponse> changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeStreamPoolCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateConnectHarnessResponse> createConnectHarness(CreateConnectHarnessRequest request) {
        return Mono.create(sink -> this.client.createConnectHarness(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateStreamResponse> createStream(CreateStreamRequest request) {
        return Mono.create(sink -> this.client.createStream(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateStreamPoolResponse> createStreamPool(CreateStreamPoolRequest request) {
        return Mono.create(sink -> this.client.createStreamPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteConnectHarnessResponse> deleteConnectHarness(DeleteConnectHarnessRequest request) {
        return Mono.create(sink -> this.client.deleteConnectHarness(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteStreamResponse> deleteStream(DeleteStreamRequest request) {
        return Mono.create(sink -> this.client.deleteStream(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteStreamPoolResponse> deleteStreamPool(DeleteStreamPoolRequest request) {
        return Mono.create(sink -> this.client.deleteStreamPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetConnectHarnessResponse> getConnectHarness(GetConnectHarnessRequest request) {
        return Mono.create(sink -> this.client.getConnectHarness(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetStreamResponse> getStream(GetStreamRequest request) {
        return Mono.create(sink -> this.client.getStream(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetStreamPoolResponse> getStreamPool(GetStreamPoolRequest request) {
        return Mono.create(sink -> this.client.getStreamPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListConnectHarnessesResponse> listConnectHarnesses(ListConnectHarnessesRequest request) {
        return Mono.create(sink -> this.client.listConnectHarnesses(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListStreamPoolsResponse> listStreamPools(ListStreamPoolsRequest request) {
        return Mono.create(sink -> this.client.listStreamPools(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListStreamsResponse> listStreams(ListStreamsRequest request) {
        return Mono.create(sink -> this.client.listStreams(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateConnectHarnessResponse> updateConnectHarness(UpdateConnectHarnessRequest request) {
        return Mono.create(sink -> this.client.updateConnectHarness(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateStreamResponse> updateStream(UpdateStreamRequest request) {
        return Mono.create(sink -> this.client.updateStream(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateStreamPoolResponse> updateStreamPool(UpdateStreamPoolRequest request) {
        return Mono.create(sink -> this.client.updateStreamPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

