/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.securityattribute;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.securityattribute.SecurityAttributeAsyncClient;
import com.oracle.bmc.securityattribute.requests.BulkDeleteSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.requests.BulkEditSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.requests.CascadingDeleteSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.ChangeSecurityAttributeNamespaceCompartmentRequest;
import com.oracle.bmc.securityattribute.requests.CreateSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.CreateSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.DeleteSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.DeleteSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeWorkRequestRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeNamespacesRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestErrorsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestLogsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.requests.UpdateSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.UpdateSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.responses.BulkDeleteSecurityAttributesResponse;
import com.oracle.bmc.securityattribute.responses.BulkEditSecurityAttributesResponse;
import com.oracle.bmc.securityattribute.responses.CascadingDeleteSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.ChangeSecurityAttributeNamespaceCompartmentResponse;
import com.oracle.bmc.securityattribute.responses.CreateSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.CreateSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.DeleteSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.DeleteSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeWorkRequestResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeNamespacesResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestErrorsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestLogsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributesResponse;
import com.oracle.bmc.securityattribute.responses.UpdateSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.UpdateSecurityAttributeResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={SecurityAttributeAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SecurityAttributeReactorClient {
    SecurityAttributeAsyncClient client;

    SecurityAttributeReactorClient(SecurityAttributeAsyncClient client) {
        this.client = client;
    }

    public Mono<BulkDeleteSecurityAttributesResponse> bulkDeleteSecurityAttributes(BulkDeleteSecurityAttributesRequest request) {
        return Mono.create(sink -> this.client.bulkDeleteSecurityAttributes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<BulkEditSecurityAttributesResponse> bulkEditSecurityAttributes(BulkEditSecurityAttributesRequest request) {
        return Mono.create(sink -> this.client.bulkEditSecurityAttributes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CascadingDeleteSecurityAttributeNamespaceResponse> cascadingDeleteSecurityAttributeNamespace(CascadingDeleteSecurityAttributeNamespaceRequest request) {
        return Mono.create(sink -> this.client.cascadingDeleteSecurityAttributeNamespace(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeSecurityAttributeNamespaceCompartmentResponse> changeSecurityAttributeNamespaceCompartment(ChangeSecurityAttributeNamespaceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeSecurityAttributeNamespaceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSecurityAttributeResponse> createSecurityAttribute(CreateSecurityAttributeRequest request) {
        return Mono.create(sink -> this.client.createSecurityAttribute(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSecurityAttributeNamespaceResponse> createSecurityAttributeNamespace(CreateSecurityAttributeNamespaceRequest request) {
        return Mono.create(sink -> this.client.createSecurityAttributeNamespace(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSecurityAttributeResponse> deleteSecurityAttribute(DeleteSecurityAttributeRequest request) {
        return Mono.create(sink -> this.client.deleteSecurityAttribute(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSecurityAttributeNamespaceResponse> deleteSecurityAttributeNamespace(DeleteSecurityAttributeNamespaceRequest request) {
        return Mono.create(sink -> this.client.deleteSecurityAttributeNamespace(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSecurityAttributeResponse> getSecurityAttribute(GetSecurityAttributeRequest request) {
        return Mono.create(sink -> this.client.getSecurityAttribute(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSecurityAttributeNamespaceResponse> getSecurityAttributeNamespace(GetSecurityAttributeNamespaceRequest request) {
        return Mono.create(sink -> this.client.getSecurityAttributeNamespace(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSecurityAttributeWorkRequestResponse> getSecurityAttributeWorkRequest(GetSecurityAttributeWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getSecurityAttributeWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSecurityAttributeNamespacesResponse> listSecurityAttributeNamespaces(ListSecurityAttributeNamespacesRequest request) {
        return Mono.create(sink -> this.client.listSecurityAttributeNamespaces(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSecurityAttributeWorkRequestErrorsResponse> listSecurityAttributeWorkRequestErrors(ListSecurityAttributeWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listSecurityAttributeWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSecurityAttributeWorkRequestLogsResponse> listSecurityAttributeWorkRequestLogs(ListSecurityAttributeWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listSecurityAttributeWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSecurityAttributeWorkRequestsResponse> listSecurityAttributeWorkRequests(ListSecurityAttributeWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listSecurityAttributeWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSecurityAttributesResponse> listSecurityAttributes(ListSecurityAttributesRequest request) {
        return Mono.create(sink -> this.client.listSecurityAttributes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSecurityAttributeResponse> updateSecurityAttribute(UpdateSecurityAttributeRequest request) {
        return Mono.create(sink -> this.client.updateSecurityAttribute(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSecurityAttributeNamespaceResponse> updateSecurityAttributeNamespace(UpdateSecurityAttributeNamespaceRequest request) {
        return Mono.create(sink -> this.client.updateSecurityAttributeNamespace(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

