/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.resourcesearch;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.resourcesearch.ResourceSearchAsyncClient;
import com.oracle.bmc.resourcesearch.requests.GetResourceTypeRequest;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.requests.SearchResourcesRequest;
import com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcesearch.responses.SearchResourcesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ResourceSearchAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ResourceSearchReactorClient {
    ResourceSearchAsyncClient client;

    ResourceSearchReactorClient(ResourceSearchAsyncClient client) {
        this.client = client;
    }

    public Mono<GetResourceTypeResponse> getResourceType(GetResourceTypeRequest request) {
        return Mono.create(sink -> this.client.getResourceType(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request) {
        return Mono.create(sink -> this.client.listResourceTypes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SearchResourcesResponse> searchResources(SearchResourcesRequest request) {
        return Mono.create(sink -> this.client.searchResources(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

