/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.resourcescheduler;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.resourcescheduler.ScheduleAsyncClient;
import com.oracle.bmc.resourcescheduler.requests.ActivateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.CancelWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.requests.ChangeScheduleCompartmentRequest;
import com.oracle.bmc.resourcescheduler.requests.CreateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.DeactivateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.DeleteScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListSchedulesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcescheduler.requests.UpdateScheduleRequest;
import com.oracle.bmc.resourcescheduler.responses.ActivateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.CancelWorkRequestResponse;
import com.oracle.bmc.resourcescheduler.responses.ChangeScheduleCompartmentResponse;
import com.oracle.bmc.resourcescheduler.responses.CreateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.DeactivateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.DeleteScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcescheduler.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListSchedulesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcescheduler.responses.UpdateScheduleResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ScheduleAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ScheduleReactorClient {
    ScheduleAsyncClient client;

    ScheduleReactorClient(ScheduleAsyncClient client) {
        this.client = client;
    }

    public Mono<ActivateScheduleResponse> activateSchedule(ActivateScheduleRequest request) {
        return Mono.create(sink -> this.client.activateSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeScheduleCompartmentResponse> changeScheduleCompartment(ChangeScheduleCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeScheduleCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateScheduleResponse> createSchedule(CreateScheduleRequest request) {
        return Mono.create(sink -> this.client.createSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeactivateScheduleResponse> deactivateSchedule(DeactivateScheduleRequest request) {
        return Mono.create(sink -> this.client.deactivateSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest request) {
        return Mono.create(sink -> this.client.deleteSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetScheduleResponse> getSchedule(GetScheduleRequest request) {
        return Mono.create(sink -> this.client.getSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request) {
        return Mono.create(sink -> this.client.listResourceTypes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSchedulesResponse> listSchedules(ListSchedulesRequest request) {
        return Mono.create(sink -> this.client.listSchedules(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateScheduleResponse> updateSchedule(UpdateScheduleRequest request) {
        return Mono.create(sink -> this.client.updateSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

