/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.recovery;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.recovery.DatabaseRecoveryAsyncClient;
import com.oracle.bmc.recovery.requests.CancelProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseSubscriptionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectionPolicyCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeRecoveryServiceSubnetCompartmentRequest;
import com.oracle.bmc.recovery.requests.CreateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.CreateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.CreateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.DeleteRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.FetchProtectedDatabaseConfigurationRequest;
import com.oracle.bmc.recovery.requests.GetProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.GetProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestsRequest;
import com.oracle.bmc.recovery.requests.ScheduleProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.UpdateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.responses.CancelProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseSubscriptionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectionPolicyCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeRecoveryServiceSubnetCompartmentResponse;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.CreateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.CreateRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.DeleteRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.FetchProtectedDatabaseConfigurationResponse;
import com.oracle.bmc.recovery.responses.GetProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.GetProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.GetRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.GetWorkRequestResponse;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestsResponse;
import com.oracle.bmc.recovery.responses.ScheduleProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.UpdateRecoveryServiceSubnetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DatabaseRecoveryAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DatabaseRecoveryReactorClient {
    DatabaseRecoveryAsyncClient client;

    DatabaseRecoveryReactorClient(DatabaseRecoveryAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelProtectedDatabaseDeletionResponse> cancelProtectedDatabaseDeletion(CancelProtectedDatabaseDeletionRequest request) {
        return Mono.create(sink -> this.client.cancelProtectedDatabaseDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeProtectedDatabaseCompartmentResponse> changeProtectedDatabaseCompartment(ChangeProtectedDatabaseCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeProtectedDatabaseCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeProtectedDatabaseSubscriptionResponse> changeProtectedDatabaseSubscription(ChangeProtectedDatabaseSubscriptionRequest request) {
        return Mono.create(sink -> this.client.changeProtectedDatabaseSubscription(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeProtectionPolicyCompartmentResponse> changeProtectionPolicyCompartment(ChangeProtectionPolicyCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeProtectionPolicyCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeRecoveryServiceSubnetCompartmentResponse> changeRecoveryServiceSubnetCompartment(ChangeRecoveryServiceSubnetCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeRecoveryServiceSubnetCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateProtectedDatabaseResponse> createProtectedDatabase(CreateProtectedDatabaseRequest request) {
        return Mono.create(sink -> this.client.createProtectedDatabase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateProtectionPolicyResponse> createProtectionPolicy(CreateProtectionPolicyRequest request) {
        return Mono.create(sink -> this.client.createProtectionPolicy(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateRecoveryServiceSubnetResponse> createRecoveryServiceSubnet(CreateRecoveryServiceSubnetRequest request) {
        return Mono.create(sink -> this.client.createRecoveryServiceSubnet(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteProtectedDatabaseResponse> deleteProtectedDatabase(DeleteProtectedDatabaseRequest request) {
        return Mono.create(sink -> this.client.deleteProtectedDatabase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteProtectionPolicyResponse> deleteProtectionPolicy(DeleteProtectionPolicyRequest request) {
        return Mono.create(sink -> this.client.deleteProtectionPolicy(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRecoveryServiceSubnetResponse> deleteRecoveryServiceSubnet(DeleteRecoveryServiceSubnetRequest request) {
        return Mono.create(sink -> this.client.deleteRecoveryServiceSubnet(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<FetchProtectedDatabaseConfigurationResponse> fetchProtectedDatabaseConfiguration(FetchProtectedDatabaseConfigurationRequest request) {
        return Mono.create(sink -> this.client.fetchProtectedDatabaseConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetProtectedDatabaseResponse> getProtectedDatabase(GetProtectedDatabaseRequest request) {
        return Mono.create(sink -> this.client.getProtectedDatabase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetProtectionPolicyResponse> getProtectionPolicy(GetProtectionPolicyRequest request) {
        return Mono.create(sink -> this.client.getProtectionPolicy(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRecoveryServiceSubnetResponse> getRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request) {
        return Mono.create(sink -> this.client.getRecoveryServiceSubnet(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListProtectedDatabasesResponse> listProtectedDatabases(ListProtectedDatabasesRequest request) {
        return Mono.create(sink -> this.client.listProtectedDatabases(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListProtectionPoliciesResponse> listProtectionPolicies(ListProtectionPoliciesRequest request) {
        return Mono.create(sink -> this.client.listProtectionPolicies(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRecoveryServiceSubnetsResponse> listRecoveryServiceSubnets(ListRecoveryServiceSubnetsRequest request) {
        return Mono.create(sink -> this.client.listRecoveryServiceSubnets(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ScheduleProtectedDatabaseDeletionResponse> scheduleProtectedDatabaseDeletion(ScheduleProtectedDatabaseDeletionRequest request) {
        return Mono.create(sink -> this.client.scheduleProtectedDatabaseDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateProtectedDatabaseResponse> updateProtectedDatabase(UpdateProtectedDatabaseRequest request) {
        return Mono.create(sink -> this.client.updateProtectedDatabase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateProtectionPolicyResponse> updateProtectionPolicy(UpdateProtectionPolicyRequest request) {
        return Mono.create(sink -> this.client.updateProtectionPolicy(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRecoveryServiceSubnetResponse> updateRecoveryServiceSubnet(UpdateRecoveryServiceSubnetRequest request) {
        return Mono.create(sink -> this.client.updateRecoveryServiceSubnet(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

