/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.queue;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.queue.QueueAdminAsyncClient;
import com.oracle.bmc.queue.requests.ChangeQueueCompartmentRequest;
import com.oracle.bmc.queue.requests.CreateQueueRequest;
import com.oracle.bmc.queue.requests.DeleteQueueRequest;
import com.oracle.bmc.queue.requests.GetQueueRequest;
import com.oracle.bmc.queue.requests.GetWorkRequestRequest;
import com.oracle.bmc.queue.requests.ListQueuesRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestsRequest;
import com.oracle.bmc.queue.requests.PurgeQueueRequest;
import com.oracle.bmc.queue.requests.UpdateQueueRequest;
import com.oracle.bmc.queue.responses.ChangeQueueCompartmentResponse;
import com.oracle.bmc.queue.responses.CreateQueueResponse;
import com.oracle.bmc.queue.responses.DeleteQueueResponse;
import com.oracle.bmc.queue.responses.GetQueueResponse;
import com.oracle.bmc.queue.responses.GetWorkRequestResponse;
import com.oracle.bmc.queue.responses.ListQueuesResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestsResponse;
import com.oracle.bmc.queue.responses.PurgeQueueResponse;
import com.oracle.bmc.queue.responses.UpdateQueueResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={QueueAdminAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class QueueAdminReactorClient {
    QueueAdminAsyncClient client;

    QueueAdminReactorClient(QueueAdminAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeQueueCompartmentResponse> changeQueueCompartment(ChangeQueueCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeQueueCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateQueueResponse> createQueue(CreateQueueRequest request) {
        return Mono.create(sink -> this.client.createQueue(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteQueueResponse> deleteQueue(DeleteQueueRequest request) {
        return Mono.create(sink -> this.client.deleteQueue(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetQueueResponse> getQueue(GetQueueRequest request) {
        return Mono.create(sink -> this.client.getQueue(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListQueuesResponse> listQueues(ListQueuesRequest request) {
        return Mono.create(sink -> this.client.listQueues(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<PurgeQueueResponse> purgeQueue(PurgeQueueRequest request) {
        return Mono.create(sink -> this.client.purgeQueue(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateQueueResponse> updateQueue(UpdateQueueRequest request) {
        return Mono.create(sink -> this.client.updateQueue(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

