/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagement.OsManagementAsyncClient;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DisableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.EnableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.ManageModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemoveModuleStreamProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.SwitchModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DisableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.EnableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.ManageModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemoveModuleStreamProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.SwitchModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OsManagementAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OsManagementReactorClient {
    OsManagementAsyncClient client;

    OsManagementReactorClient(OsManagementAsyncClient client) {
        this.client = client;
    }

    public Mono<AddPackagesToSoftwareSourceResponse> addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.addPackagesToSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<AttachChildSoftwareSourceToManagedInstanceResponse> attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.attachChildSoftwareSourceToManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<AttachManagedInstanceToManagedInstanceGroupResponse> attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.attachManagedInstanceToManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<AttachParentSoftwareSourceToManagedInstanceResponse> attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.attachParentSoftwareSourceToManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeManagedInstanceGroupCompartmentResponse> changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeManagedInstanceGroupCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeScheduledJobCompartmentResponse> changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeScheduledJobCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeSoftwareSourceCompartmentResponse> changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeSoftwareSourceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateManagedInstanceGroupResponse> createManagedInstanceGroup(CreateManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.createManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateScheduledJobResponse> createScheduledJob(CreateScheduledJobRequest request) {
        return Mono.create(sink -> this.client.createScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSoftwareSourceResponse> createSoftwareSource(CreateSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.createSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteManagedInstanceGroupResponse> deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.deleteManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteScheduledJobResponse> deleteScheduledJob(DeleteScheduledJobRequest request) {
        return Mono.create(sink -> this.client.deleteScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSoftwareSourceResponse> deleteSoftwareSource(DeleteSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.deleteSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DetachChildSoftwareSourceFromManagedInstanceResponse> detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.detachChildSoftwareSourceFromManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DetachManagedInstanceFromManagedInstanceGroupResponse> detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.detachManagedInstanceFromManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DetachParentSoftwareSourceFromManagedInstanceResponse> detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.detachParentSoftwareSourceFromManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DisableModuleStreamOnManagedInstanceResponse> disableModuleStreamOnManagedInstance(DisableModuleStreamOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.disableModuleStreamOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<EnableModuleStreamOnManagedInstanceResponse> enableModuleStreamOnManagedInstance(EnableModuleStreamOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.enableModuleStreamOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetErratumResponse> getErratum(GetErratumRequest request) {
        return Mono.create(sink -> this.client.getErratum(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetManagedInstanceResponse> getManagedInstance(GetManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.getManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetManagedInstanceGroupResponse> getManagedInstanceGroup(GetManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.getManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetModuleStreamResponse> getModuleStream(GetModuleStreamRequest request) {
        return Mono.create(sink -> this.client.getModuleStream(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetModuleStreamProfileResponse> getModuleStreamProfile(GetModuleStreamProfileRequest request) {
        return Mono.create(sink -> this.client.getModuleStreamProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetScheduledJobResponse> getScheduledJob(GetScheduledJobRequest request) {
        return Mono.create(sink -> this.client.getScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSoftwarePackageResponse> getSoftwarePackage(GetSoftwarePackageRequest request) {
        return Mono.create(sink -> this.client.getSoftwarePackage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSoftwareSourceResponse> getSoftwareSource(GetSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.getSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWindowsUpdateResponse> getWindowsUpdate(GetWindowsUpdateRequest request) {
        return Mono.create(sink -> this.client.getWindowsUpdate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallAllPackageUpdatesOnManagedInstanceResponse> installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.installAllPackageUpdatesOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallAllUpdatesOnManagedInstanceGroupResponse> installAllUpdatesOnManagedInstanceGroup(InstallAllUpdatesOnManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.installAllUpdatesOnManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallAllWindowsUpdatesOnManagedInstanceResponse> installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.installAllWindowsUpdatesOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallModuleStreamProfileOnManagedInstanceResponse> installModuleStreamProfileOnManagedInstance(InstallModuleStreamProfileOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.installModuleStreamProfileOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallPackageOnManagedInstanceResponse> installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.installPackageOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallPackageUpdateOnManagedInstanceResponse> installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.installPackageUpdateOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<InstallWindowsUpdateOnManagedInstanceResponse> installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.installWindowsUpdateOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAvailablePackagesForManagedInstanceResponse> listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listAvailablePackagesForManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAvailableSoftwareSourcesForManagedInstanceResponse> listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listAvailableSoftwareSourcesForManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAvailableUpdatesForManagedInstanceResponse> listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listAvailableUpdatesForManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAvailableWindowsUpdatesForManagedInstanceResponse> listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listAvailableWindowsUpdatesForManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListErrataResponse> listErrata(ListErrataRequest request) {
        return Mono.create(sink -> this.client.listErrata(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListManagedInstanceErrataResponse> listManagedInstanceErrata(ListManagedInstanceErrataRequest request) {
        return Mono.create(sink -> this.client.listManagedInstanceErrata(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListManagedInstanceGroupsResponse> listManagedInstanceGroups(ListManagedInstanceGroupsRequest request) {
        return Mono.create(sink -> this.client.listManagedInstanceGroups(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListManagedInstancesResponse> listManagedInstances(ListManagedInstancesRequest request) {
        return Mono.create(sink -> this.client.listManagedInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListModuleStreamProfilesResponse> listModuleStreamProfiles(ListModuleStreamProfilesRequest request) {
        return Mono.create(sink -> this.client.listModuleStreamProfiles(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListModuleStreamProfilesOnManagedInstanceResponse> listModuleStreamProfilesOnManagedInstance(ListModuleStreamProfilesOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listModuleStreamProfilesOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListModuleStreamsResponse> listModuleStreams(ListModuleStreamsRequest request) {
        return Mono.create(sink -> this.client.listModuleStreams(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListModuleStreamsOnManagedInstanceResponse> listModuleStreamsOnManagedInstance(ListModuleStreamsOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listModuleStreamsOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListPackagesInstalledOnManagedInstanceResponse> listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listPackagesInstalledOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListScheduledJobsResponse> listScheduledJobs(ListScheduledJobsRequest request) {
        return Mono.create(sink -> this.client.listScheduledJobs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSoftwareSourcePackagesResponse> listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request) {
        return Mono.create(sink -> this.client.listSoftwareSourcePackages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSoftwareSourcesResponse> listSoftwareSources(ListSoftwareSourcesRequest request) {
        return Mono.create(sink -> this.client.listSoftwareSources(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListUpcomingScheduledJobsResponse> listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request) {
        return Mono.create(sink -> this.client.listUpcomingScheduledJobs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWindowsUpdatesResponse> listWindowsUpdates(ListWindowsUpdatesRequest request) {
        return Mono.create(sink -> this.client.listWindowsUpdates(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWindowsUpdatesInstalledOnManagedInstanceResponse> listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.listWindowsUpdatesInstalledOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ManageModuleStreamsOnManagedInstanceResponse> manageModuleStreamsOnManagedInstance(ManageModuleStreamsOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.manageModuleStreamsOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveModuleStreamProfileFromManagedInstanceResponse> removeModuleStreamProfileFromManagedInstance(RemoveModuleStreamProfileFromManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.removeModuleStreamProfileFromManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemovePackageFromManagedInstanceResponse> removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.removePackageFromManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemovePackagesFromSoftwareSourceResponse> removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.removePackagesFromSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RunScheduledJobNowResponse> runScheduledJobNow(RunScheduledJobNowRequest request) {
        return Mono.create(sink -> this.client.runScheduledJobNow(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SearchSoftwarePackagesResponse> searchSoftwarePackages(SearchSoftwarePackagesRequest request) {
        return Mono.create(sink -> this.client.searchSoftwarePackages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SkipNextScheduledJobExecutionResponse> skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request) {
        return Mono.create(sink -> this.client.skipNextScheduledJobExecution(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SwitchModuleStreamOnManagedInstanceResponse> switchModuleStreamOnManagedInstance(SwitchModuleStreamOnManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.switchModuleStreamOnManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateManagedInstanceResponse> updateManagedInstance(UpdateManagedInstanceRequest request) {
        return Mono.create(sink -> this.client.updateManagedInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateManagedInstanceGroupResponse> updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request) {
        return Mono.create(sink -> this.client.updateManagedInstanceGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateScheduledJobResponse> updateScheduledJob(UpdateScheduledJobRequest request) {
        return Mono.create(sink -> this.client.updateScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSoftwareSourceResponse> updateSoftwareSource(UpdateSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.updateSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

