/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.osmanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagement.EventAsyncClient;
import com.oracle.bmc.osmanagement.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.requests.GetEventRequest;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagement.requests.UploadEventContentRequest;
import com.oracle.bmc.osmanagement.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.osmanagement.responses.GetEventResponse;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.osmanagement.responses.UpdateEventResponse;
import com.oracle.bmc.osmanagement.responses.UploadEventContentResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={EventAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EventRxClient {
    EventAsyncClient client;

    EventRxClient(EventAsyncClient client) {
        this.client = client;
    }

    public Single<DeleteEventContentResponse> deleteEventContent(DeleteEventContentRequest request) {
        return Single.create(emitter -> this.client.deleteEventContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEventResponse> getEvent(GetEventRequest request) {
        return Single.create(emitter -> this.client.getEvent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEventContentResponse> getEventContent(GetEventContentRequest request) {
        return Single.create(emitter -> this.client.getEventContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEventReportResponse> getEventReport(GetEventReportRequest request) {
        return Single.create(emitter -> this.client.getEventReport(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEventsResponse> listEvents(ListEventsRequest request) {
        return Single.create(emitter -> this.client.listEvents(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRelatedEventsResponse> listRelatedEvents(ListRelatedEventsRequest request) {
        return Single.create(emitter -> this.client.listRelatedEvents(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateEventResponse> updateEvent(UpdateEventRequest request) {
        return Single.create(emitter -> this.client.updateEvent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UploadEventContentResponse> uploadEventContent(UploadEventContentRequest request) {
        return Single.create(emitter -> this.client.uploadEventContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

