/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagement.EventAsyncClient;
import com.oracle.bmc.osmanagement.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.requests.GetEventRequest;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagement.requests.UploadEventContentRequest;
import com.oracle.bmc.osmanagement.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.osmanagement.responses.GetEventResponse;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.osmanagement.responses.UpdateEventResponse;
import com.oracle.bmc.osmanagement.responses.UploadEventContentResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={EventAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EventReactorClient {
    EventAsyncClient client;

    EventReactorClient(EventAsyncClient client) {
        this.client = client;
    }

    public Mono<DeleteEventContentResponse> deleteEventContent(DeleteEventContentRequest request) {
        return Mono.create(sink -> this.client.deleteEventContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEventResponse> getEvent(GetEventRequest request) {
        return Mono.create(sink -> this.client.getEvent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEventContentResponse> getEventContent(GetEventContentRequest request) {
        return Mono.create(sink -> this.client.getEventContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEventReportResponse> getEventReport(GetEventReportRequest request) {
        return Mono.create(sink -> this.client.getEventReport(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEventsResponse> listEvents(ListEventsRequest request) {
        return Mono.create(sink -> this.client.listEvents(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRelatedEventsResponse> listRelatedEvents(ListRelatedEventsRequest request) {
        return Mono.create(sink -> this.client.listRelatedEvents(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateEventResponse> updateEvent(UpdateEventRequest request) {
        return Mono.create(sink -> this.client.updateEvent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UploadEventContentResponse> uploadEventContent(UploadEventContentRequest request) {
        return Mono.create(sink -> this.client.uploadEventContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

