/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.ocicontrolcenter;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ocicontrolcenter.OccMetricsAsyncClient;
import com.oracle.bmc.ocicontrolcenter.requests.ListMetricPropertiesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.ListNamespacesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.RequestSummarizedMetricDataRequest;
import com.oracle.bmc.ocicontrolcenter.responses.ListMetricPropertiesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.ListNamespacesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.RequestSummarizedMetricDataResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OccMetricsAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OccMetricsReactorClient {
    OccMetricsAsyncClient client;

    OccMetricsReactorClient(OccMetricsAsyncClient client) {
        this.client = client;
    }

    public Mono<ListMetricPropertiesResponse> listMetricProperties(ListMetricPropertiesRequest request) {
        return Mono.create(sink -> this.client.listMetricProperties(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListNamespacesResponse> listNamespaces(ListNamespacesRequest request) {
        return Mono.create(sink -> this.client.listNamespaces(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RequestSummarizedMetricDataResponse> requestSummarizedMetricData(RequestSummarizedMetricDataRequest request) {
        return Mono.create(sink -> this.client.requestSummarizedMetricData(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

