/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.oce;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.oce.OceInstanceAsyncClient;
import com.oracle.bmc.oce.requests.ChangeOceInstanceCompartmentRequest;
import com.oracle.bmc.oce.requests.CreateOceInstanceRequest;
import com.oracle.bmc.oce.requests.DeleteOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.requests.ListOceInstancesRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oce.requests.UpdateOceInstanceRequest;
import com.oracle.bmc.oce.responses.ChangeOceInstanceCompartmentResponse;
import com.oracle.bmc.oce.responses.CreateOceInstanceResponse;
import com.oracle.bmc.oce.responses.DeleteOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.oce.responses.ListOceInstancesResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oce.responses.UpdateOceInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OceInstanceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OceInstanceReactorClient {
    OceInstanceAsyncClient client;

    OceInstanceReactorClient(OceInstanceAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeOceInstanceCompartmentResponse> changeOceInstanceCompartment(ChangeOceInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeOceInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateOceInstanceResponse> createOceInstance(CreateOceInstanceRequest request) {
        return Mono.create(sink -> this.client.createOceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteOceInstanceResponse> deleteOceInstance(DeleteOceInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteOceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetOceInstanceResponse> getOceInstance(GetOceInstanceRequest request) {
        return Mono.create(sink -> this.client.getOceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListOceInstancesResponse> listOceInstances(ListOceInstancesRequest request) {
        return Mono.create(sink -> this.client.listOceInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateOceInstanceResponse> updateOceInstance(UpdateOceInstanceRequest request) {
        return Mono.create(sink -> this.client.updateOceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

