/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.ReplicasAsyncClient;
import com.oracle.bmc.mysql.requests.CreateReplicaRequest;
import com.oracle.bmc.mysql.requests.DeleteReplicaRequest;
import com.oracle.bmc.mysql.requests.GetReplicaRequest;
import com.oracle.bmc.mysql.requests.ListReplicasRequest;
import com.oracle.bmc.mysql.requests.UpdateReplicaRequest;
import com.oracle.bmc.mysql.responses.CreateReplicaResponse;
import com.oracle.bmc.mysql.responses.DeleteReplicaResponse;
import com.oracle.bmc.mysql.responses.GetReplicaResponse;
import com.oracle.bmc.mysql.responses.ListReplicasResponse;
import com.oracle.bmc.mysql.responses.UpdateReplicaResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ReplicasAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ReplicasReactorClient {
    ReplicasAsyncClient client;

    ReplicasReactorClient(ReplicasAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateReplicaResponse> createReplica(CreateReplicaRequest request) {
        return Mono.create(sink -> this.client.createReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteReplicaResponse> deleteReplica(DeleteReplicaRequest request) {
        return Mono.create(sink -> this.client.deleteReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetReplicaResponse> getReplica(GetReplicaRequest request) {
        return Mono.create(sink -> this.client.getReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListReplicasResponse> listReplicas(ListReplicasRequest request) {
        return Mono.create(sink -> this.client.listReplicas(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateReplicaResponse> updateReplica(UpdateReplicaRequest request) {
        return Mono.create(sink -> this.client.updateReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

