/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.ChannelsAsyncClient;
import com.oracle.bmc.mysql.requests.CreateChannelRequest;
import com.oracle.bmc.mysql.requests.DeleteChannelRequest;
import com.oracle.bmc.mysql.requests.GetChannelRequest;
import com.oracle.bmc.mysql.requests.ListChannelsRequest;
import com.oracle.bmc.mysql.requests.ResetChannelRequest;
import com.oracle.bmc.mysql.requests.ResumeChannelRequest;
import com.oracle.bmc.mysql.requests.UpdateChannelRequest;
import com.oracle.bmc.mysql.responses.CreateChannelResponse;
import com.oracle.bmc.mysql.responses.DeleteChannelResponse;
import com.oracle.bmc.mysql.responses.GetChannelResponse;
import com.oracle.bmc.mysql.responses.ListChannelsResponse;
import com.oracle.bmc.mysql.responses.ResetChannelResponse;
import com.oracle.bmc.mysql.responses.ResumeChannelResponse;
import com.oracle.bmc.mysql.responses.UpdateChannelResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ChannelsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ChannelsRxClient {
    ChannelsAsyncClient client;

    ChannelsRxClient(ChannelsAsyncClient client) {
        this.client = client;
    }

    public Single<CreateChannelResponse> createChannel(CreateChannelRequest request) {
        return Single.create(emitter -> this.client.createChannel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteChannelResponse> deleteChannel(DeleteChannelRequest request) {
        return Single.create(emitter -> this.client.deleteChannel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetChannelResponse> getChannel(GetChannelRequest request) {
        return Single.create(emitter -> this.client.getChannel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListChannelsResponse> listChannels(ListChannelsRequest request) {
        return Single.create(emitter -> this.client.listChannels(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ResetChannelResponse> resetChannel(ResetChannelRequest request) {
        return Single.create(emitter -> this.client.resetChannel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ResumeChannelResponse> resumeChannel(ResumeChannelRequest request) {
        return Single.create(emitter -> this.client.resumeChannel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateChannelResponse> updateChannel(UpdateChannelRequest request) {
        return Single.create(emitter -> this.client.updateChannel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

