/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.WorkRequestsAsyncClient;
import com.oracle.bmc.mysql.requests.GetWorkRequestRequest;
import com.oracle.bmc.mysql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.mysql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.mysql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.mysql.responses.GetWorkRequestResponse;
import com.oracle.bmc.mysql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.mysql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.mysql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={WorkRequestsAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WorkRequestsReactorClient {
    WorkRequestsAsyncClient client;

    WorkRequestsReactorClient(WorkRequestsAsyncClient client) {
        this.client = client;
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

