/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.MysqlaasAsyncClient;
import com.oracle.bmc.mysql.requests.CreateConfigurationRequest;
import com.oracle.bmc.mysql.requests.DeleteConfigurationRequest;
import com.oracle.bmc.mysql.requests.GetConfigurationRequest;
import com.oracle.bmc.mysql.requests.ListConfigurationsRequest;
import com.oracle.bmc.mysql.requests.ListShapesRequest;
import com.oracle.bmc.mysql.requests.ListVersionsRequest;
import com.oracle.bmc.mysql.requests.UpdateConfigurationRequest;
import com.oracle.bmc.mysql.responses.CreateConfigurationResponse;
import com.oracle.bmc.mysql.responses.DeleteConfigurationResponse;
import com.oracle.bmc.mysql.responses.GetConfigurationResponse;
import com.oracle.bmc.mysql.responses.ListConfigurationsResponse;
import com.oracle.bmc.mysql.responses.ListShapesResponse;
import com.oracle.bmc.mysql.responses.ListVersionsResponse;
import com.oracle.bmc.mysql.responses.UpdateConfigurationResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={MysqlaasAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MysqlaasReactorClient {
    MysqlaasAsyncClient client;

    MysqlaasReactorClient(MysqlaasAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateConfigurationResponse> createConfiguration(CreateConfigurationRequest request) {
        return Mono.create(sink -> this.client.createConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteConfigurationResponse> deleteConfiguration(DeleteConfigurationRequest request) {
        return Mono.create(sink -> this.client.deleteConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request) {
        return Mono.create(sink -> this.client.getConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest request) {
        return Mono.create(sink -> this.client.listConfigurations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListShapesResponse> listShapes(ListShapesRequest request) {
        return Mono.create(sink -> this.client.listShapes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListVersionsResponse> listVersions(ListVersionsRequest request) {
        return Mono.create(sink -> this.client.listVersions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request) {
        return Mono.create(sink -> this.client.updateConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

