/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.DbSystemAsyncClient;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.GenerateHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.RestartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.GenerateHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.RestartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateHeatWaveClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DbSystemAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DbSystemReactorClient {
    DbSystemAsyncClient client;

    DbSystemReactorClient(DbSystemAsyncClient client) {
        this.client = client;
    }

    public Mono<AddHeatWaveClusterResponse> addHeatWaveCluster(AddHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.addHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDbSystemResponse> createDbSystem(CreateDbSystemRequest request) {
        return Mono.create(sink -> this.client.createDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDbSystemResponse> deleteDbSystem(DeleteDbSystemRequest request) {
        return Mono.create(sink -> this.client.deleteDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteHeatWaveClusterResponse> deleteHeatWaveCluster(DeleteHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.deleteHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GenerateHeatWaveClusterMemoryEstimateResponse> generateHeatWaveClusterMemoryEstimate(GenerateHeatWaveClusterMemoryEstimateRequest request) {
        return Mono.create(sink -> this.client.generateHeatWaveClusterMemoryEstimate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request) {
        return Mono.create(sink -> this.client.getDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetHeatWaveClusterResponse> getHeatWaveCluster(GetHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.getHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetHeatWaveClusterMemoryEstimateResponse> getHeatWaveClusterMemoryEstimate(GetHeatWaveClusterMemoryEstimateRequest request) {
        return Mono.create(sink -> this.client.getHeatWaveClusterMemoryEstimate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request) {
        return Mono.create(sink -> this.client.listDbSystems(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestartDbSystemResponse> restartDbSystem(RestartDbSystemRequest request) {
        return Mono.create(sink -> this.client.restartDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestartHeatWaveClusterResponse> restartHeatWaveCluster(RestartHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.restartHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartDbSystemResponse> startDbSystem(StartDbSystemRequest request) {
        return Mono.create(sink -> this.client.startDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartHeatWaveClusterResponse> startHeatWaveCluster(StartHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.startHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StopDbSystemResponse> stopDbSystem(StopDbSystemRequest request) {
        return Mono.create(sink -> this.client.stopDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StopHeatWaveClusterResponse> stopHeatWaveCluster(StopHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.stopHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request) {
        return Mono.create(sink -> this.client.updateDbSystem(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateHeatWaveClusterResponse> updateHeatWaveCluster(UpdateHeatWaveClusterRequest request) {
        return Mono.create(sink -> this.client.updateHeatWaveCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

